package io.github.kaposke.services;

import static io.github.kaposke.http.ParameterConverter.toQueryParameterValue;

import io.github.kaposke.Configuration;
import io.github.kaposke.exceptions.ApiException;
import io.github.kaposke.http.*;
import io.github.kaposke.models.BaseModel;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class BuildService extends BaseService implements BuildClient {

  public BuildService(OkHttpClient httpClient) {
    super(httpClient);
  }

  public io.github.kaposke.models.BuildResponse buildSdk(
    io.github.kaposke.models.CreateSdkBuildRequest input
  ) throws ApiException {
    String url = HttpUrl
      .parse(Configuration.SERVER_URL)
      .newBuilder()
      .addPathSegment("builds")
      .addPathSegment("sdk")
      .build()
      .toString();
    RequestBody requestBody = RequestBody.create(
      ModelConverter.modelToJson(input),
      okhttp3.MediaType.parse("application/json; charset=utf-8")
    );
    Request request = new Request.Builder().url(url).post(requestBody).build();
    Response response = this.execute(request);

    return ModelConverter.convert(
      response,
      new com.fasterxml.jackson.core.type.TypeReference<io.github.kaposke.models.BuildResponse>() {}
    );
  }

  public io.github.kaposke.models.BuildResponse buildDoc(
    io.github.kaposke.models.BuildDocRequest input
  ) throws ApiException {
    String url = HttpUrl
      .parse(Configuration.SERVER_URL)
      .newBuilder()
      .addPathSegment("builds")
      .addPathSegment("doc")
      .build()
      .toString();
    RequestBody requestBody = RequestBody.create(
      ModelConverter.modelToJson(input),
      okhttp3.MediaType.parse("application/json; charset=utf-8")
    );
    Request request = new Request.Builder().url(url).post(requestBody).build();
    Response response = this.execute(request);

    return ModelConverter.convert(
      response,
      new com.fasterxml.jackson.core.type.TypeReference<io.github.kaposke.models.BuildResponse>() {}
    );
  }

  public java.util.List<io.github.kaposke.models.BuildResponse> getBuilds(float apiId)
    throws ApiException {
    String url = HttpUrl
      .parse(Configuration.SERVER_URL)
      .newBuilder()
      .addPathSegment("builds")
      .addQueryParameter("apiId", toQueryParameterValue(apiId))
      .build()
      .toString();
    Request request = new Request.Builder().url(url).get().build();
    Response response = this.execute(request);

    return ModelConverter.convert(
      response,
      new com.fasterxml.jackson.core.type.TypeReference<java.util.List<io.github.kaposke.models.BuildResponse>>() {}
    );
  }

  public io.github.kaposke.models.BuildResponse getById(float id) throws ApiException {
    String url = HttpUrl
      .parse(Configuration.SERVER_URL)
      .newBuilder()
      .addPathSegment("builds")
      .addPathSegment(String.valueOf(id))
      .build()
      .toString();
    Request request = new Request.Builder().url(url).get().build();
    Response response = this.execute(request);

    return ModelConverter.convert(
      response,
      new com.fasterxml.jackson.core.type.TypeReference<io.github.kaposke.models.BuildResponse>() {}
    );
  }
}
