package io.github.kaposke.services;

import static io.github.kaposke.http.ParameterConverter.toQueryParameterValue;

import io.github.kaposke.Configuration;
import io.github.kaposke.exceptions.ApiException;
import io.github.kaposke.http.*;
import io.github.kaposke.models.BaseModel;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class EventService extends BaseService implements EventClient {

  public EventService(OkHttpClient httpClient) {
    super(httpClient);
  }

  public String track(io.github.kaposke.models.TrackEventRequest input) throws ApiException {
    String url = HttpUrl
      .parse(Configuration.SERVER_URL)
      .newBuilder()
      .addPathSegment("events")
      .build()
      .toString();
    RequestBody requestBody = RequestBody.create(
      ModelConverter.modelToJson(input),
      okhttp3.MediaType.parse("application/json; charset=utf-8")
    );
    Request request = new Request.Builder().url(url).post(requestBody).build();
    Response response = this.execute(request);

    try {
      return response.body().string();
    } catch (IOException e) {
      e.printStackTrace();
    }
    return null;
  }
}
