package io.github.kaposke.services;

import static io.github.kaposke.http.ParameterConverter.toQueryParameterValue;

import io.github.kaposke.Configuration;
import io.github.kaposke.exceptions.ApiException;
import io.github.kaposke.http.*;
import io.github.kaposke.models.BaseModel;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OrgService extends BaseService implements OrgClient {

  public OrgService(OkHttpClient httpClient) {
    super(httpClient);
  }

  public java.util.List<io.github.kaposke.models.OrgResponse> getByCurrentUser()
    throws ApiException {
    String url = HttpUrl
      .parse(Configuration.SERVER_URL)
      .newBuilder()
      .addPathSegment("orgs")
      .build()
      .toString();
    Request request = new Request.Builder().url(url).get().build();
    Response response = this.execute(request);

    return ModelConverter.convert(
      response,
      new com.fasterxml.jackson.core.type.TypeReference<java.util.List<io.github.kaposke.models.OrgResponse>>() {}
    );
  }

  public io.github.kaposke.models.OrgResponse create(
    io.github.kaposke.models.CreateOrgRequest input
  ) throws ApiException {
    String url = HttpUrl
      .parse(Configuration.SERVER_URL)
      .newBuilder()
      .addPathSegment("orgs")
      .build()
      .toString();
    RequestBody requestBody = RequestBody.create(
      ModelConverter.modelToJson(input),
      okhttp3.MediaType.parse("application/json; charset=utf-8")
    );
    Request request = new Request.Builder().url(url).post(requestBody).build();
    Response response = this.execute(request);

    return ModelConverter.convert(
      response,
      new com.fasterxml.jackson.core.type.TypeReference<io.github.kaposke.models.OrgResponse>() {}
    );
  }

  public io.github.kaposke.models.OrgResponse getById(float id) throws ApiException {
    String url = HttpUrl
      .parse(Configuration.SERVER_URL)
      .newBuilder()
      .addPathSegment("orgs")
      .addPathSegment(String.valueOf(id))
      .build()
      .toString();
    Request request = new Request.Builder().url(url).get().build();
    Response response = this.execute(request);

    return ModelConverter.convert(
      response,
      new com.fasterxml.jackson.core.type.TypeReference<io.github.kaposke.models.OrgResponse>() {}
    );
  }

  public io.github.kaposke.models.OrgResponse update(
    io.github.kaposke.models.EditOrgRequest input,
    float id
  ) throws ApiException {
    String url = HttpUrl
      .parse(Configuration.SERVER_URL)
      .newBuilder()
      .addPathSegment("orgs")
      .addPathSegment(String.valueOf(id))
      .build()
      .toString();
    RequestBody requestBody = RequestBody.create(
      ModelConverter.modelToJson(input),
      okhttp3.MediaType.parse("application/json; charset=utf-8")
    );
    Request request = new Request.Builder().url(url).patch(requestBody).build();
    Response response = this.execute(request);

    return ModelConverter.convert(
      response,
      new com.fasterxml.jackson.core.type.TypeReference<io.github.kaposke.models.OrgResponse>() {}
    );
  }

  public String remove(float id) throws ApiException {
    String url = HttpUrl
      .parse(Configuration.SERVER_URL)
      .newBuilder()
      .addPathSegment("orgs")
      .addPathSegment(String.valueOf(id))
      .build()
      .toString();
    Request request = new Request.Builder().url(url).delete().build();
    Response response = this.execute(request);

    try {
      return response.body().string();
    } catch (IOException e) {
      e.printStackTrace();
    }
    return null;
  }

  public java.util.List<io.github.kaposke.models.ApiResponse> getApis(float id)
    throws ApiException {
    String url = HttpUrl
      .parse(Configuration.SERVER_URL)
      .newBuilder()
      .addPathSegment("orgs")
      .addPathSegment(String.valueOf(id))
      .addPathSegment("apis")
      .build()
      .toString();
    Request request = new Request.Builder().url(url).get().build();
    Response response = this.execute(request);

    return ModelConverter.convert(
      response,
      new com.fasterxml.jackson.core.type.TypeReference<java.util.List<io.github.kaposke.models.ApiResponse>>() {}
    );
  }

  public io.github.kaposke.models.OrgGetPayments200Response getPayments(float id)
    throws ApiException {
    String url = HttpUrl
      .parse(Configuration.SERVER_URL)
      .newBuilder()
      .addPathSegment("orgs")
      .addPathSegment(String.valueOf(id))
      .addPathSegment("payments")
      .build()
      .toString();
    Request request = new Request.Builder().url(url).get().build();
    Response response = this.execute(request);

    return ModelConverter.convert(
      response,
      new com.fasterxml.jackson.core.type.TypeReference<io.github.kaposke.models.OrgGetPayments200Response>() {}
    );
  }

  public java.util.List<io.github.kaposke.models.ArtifactResponse> getArtifacts(float id)
    throws ApiException {
    String url = HttpUrl
      .parse(Configuration.SERVER_URL)
      .newBuilder()
      .addPathSegment("orgs")
      .addPathSegment(String.valueOf(id))
      .addPathSegment("artifacts")
      .build()
      .toString();
    Request request = new Request.Builder().url(url).get().build();
    Response response = this.execute(request);

    return ModelConverter.convert(
      response,
      new com.fasterxml.jackson.core.type.TypeReference<java.util.List<io.github.kaposke.models.ArtifactResponse>>() {}
    );
  }

  public java.util.List<io.github.kaposke.models.DocResponse> getDocs(float id)
    throws ApiException {
    String url = HttpUrl
      .parse(Configuration.SERVER_URL)
      .newBuilder()
      .addPathSegment("orgs")
      .addPathSegment(String.valueOf(id))
      .addPathSegment("docs")
      .build()
      .toString();
    Request request = new Request.Builder().url(url).get().build();
    Response response = this.execute(request);

    return ModelConverter.convert(
      response,
      new com.fasterxml.jackson.core.type.TypeReference<java.util.List<io.github.kaposke.models.DocResponse>>() {}
    );
  }
}
