package io.github.kaposke.services;

import static io.github.kaposke.http.ParameterConverter.toQueryParameterValue;

import io.github.kaposke.Configuration;
import io.github.kaposke.exceptions.ApiException;
import io.github.kaposke.http.*;
import io.github.kaposke.models.BaseModel;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class TokenService extends BaseService implements TokenClient {

  public TokenService(OkHttpClient httpClient) {
    super(httpClient);
  }

  public io.github.kaposke.models.GetTokenResponse findByUserId(float userId) throws ApiException {
    String url = HttpUrl
      .parse(Configuration.SERVER_URL)
      .newBuilder()
      .addPathSegment("auth")
      .addPathSegment("tokens")
      .addQueryParameter("userId", toQueryParameterValue(userId))
      .build()
      .toString();
    Request request = new Request.Builder().url(url).get().build();
    Response response = this.execute(request);

    return ModelConverter.convert(
      response,
      new com.fasterxml.jackson.core.type.TypeReference<io.github.kaposke.models.GetTokenResponse>() {}
    );
  }

  public io.github.kaposke.models.CreateTokenResponse create(
    io.github.kaposke.models.CreateTokenRequest input
  ) throws ApiException {
    String url = HttpUrl
      .parse(Configuration.SERVER_URL)
      .newBuilder()
      .addPathSegment("auth")
      .addPathSegment("tokens")
      .build()
      .toString();
    RequestBody requestBody = RequestBody.create(
      ModelConverter.modelToJson(input),
      okhttp3.MediaType.parse("application/json; charset=utf-8")
    );
    Request request = new Request.Builder().url(url).post(requestBody).build();
    Response response = this.execute(request);

    return ModelConverter.convert(
      response,
      new com.fasterxml.jackson.core.type.TypeReference<io.github.kaposke.models.CreateTokenResponse>() {}
    );
  }

  public io.github.kaposke.models.GetTokenResponse getById(float id) throws ApiException {
    String url = HttpUrl
      .parse(Configuration.SERVER_URL)
      .newBuilder()
      .addPathSegment("auth")
      .addPathSegment("tokens")
      .addPathSegment(String.valueOf(id))
      .build()
      .toString();
    Request request = new Request.Builder().url(url).get().build();
    Response response = this.execute(request);

    return ModelConverter.convert(
      response,
      new com.fasterxml.jackson.core.type.TypeReference<io.github.kaposke.models.GetTokenResponse>() {}
    );
  }

  public String remove(float id) throws ApiException {
    String url = HttpUrl
      .parse(Configuration.SERVER_URL)
      .newBuilder()
      .addPathSegment("auth")
      .addPathSegment("tokens")
      .addPathSegment(String.valueOf(id))
      .build()
      .toString();
    Request request = new Request.Builder().url(url).delete().build();
    Response response = this.execute(request);

    try {
      return response.body().string();
    } catch (IOException e) {
      e.printStackTrace();
    }
    return null;
  }
}
