/*
 * Decompiled with CFR 0.152.
 */
package io.github.kaposke.hooks.model;

import io.github.kaposke.http.ModelConverter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;

public class Request {
    private String method;
    private String url;
    private String body;
    private Map<String, String> headers;

    public Request(String method, String url, String body, Map<String, String> headers) {
        this.method = method;
        this.url = url;
        this.body = body;
        this.headers = headers;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public static Request toHookRequest(okhttp3.Request request) {
        Map<String, String> hookHeaders = request.headers().toMultimap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (String)((List)entry.getValue()).get(0)));
        return new Request(request.method(), request.url().toString(), request.body() != null ? Objects.requireNonNull(request.body()).toString() : "", hookHeaders);
    }

    public static okhttp3.Request toOkHttpRequest(Request hookRequest) {
        Headers.Builder headersBuilder = new Headers.Builder();
        hookRequest.getHeaders().forEach((arg_0, arg_1) -> ((Headers.Builder)headersBuilder).add(arg_0, arg_1));
        if (hookRequest.getBody() != null && !hookRequest.getBody().isEmpty()) {
            RequestBody requestBody = RequestBody.create((String)Objects.requireNonNull(ModelConverter.modelToJson(hookRequest.getBody())), (MediaType)MediaType.parse((String)"application/json; charset=utf-8"));
            return new Request.Builder().method(hookRequest.getMethod(), requestBody).headers(headersBuilder.build()).url(hookRequest.url).build();
        }
        return new Request.Builder().method(hookRequest.getMethod(), null).headers(headersBuilder.build()).url(hookRequest.url).build();
    }
}

