/*
 * Decompiled with CFR 0.152.
 */
package io.github.kaposke.http.interceptors;

import java.io.IOException;
import java.util.stream.IntStream;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class RetryInterceptor
implements Interceptor {
    private static final int MAX_RETRIES = 3;
    private static final double RETRY_DELAY = 150.0;
    private static final int[] RETRYABLE_CODES = new int[]{500, 503, 504};

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Response response = chain.proceed(request);
        int tryCount = 1;
        while (!response.isSuccessful() && this.isRetryable(response) && tryCount - 1 < 3) {
            try {
                Thread.sleep((long)Math.pow(150.0, tryCount - 1));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            response.close();
            response = chain.proceed(request);
            ++tryCount;
        }
        return response;
    }

    private boolean isRetryable(Response response) {
        int statusCode = response.code();
        return IntStream.of(RETRYABLE_CODES).anyMatch(x -> x == statusCode);
    }
}

