/*
 * Decompiled with CFR 0.152.
 */
package io.github.kaposke.services;

import com.fasterxml.jackson.core.type.TypeReference;
import io.github.kaposke.exceptions.ApiException;
import io.github.kaposke.http.ApiClient;
import io.github.kaposke.http.ModelConverter;
import io.github.kaposke.http.ParameterConverter;
import io.github.kaposke.models.ApiResponse;
import io.github.kaposke.models.BuildResponse;
import io.github.kaposke.models.CreateApiRequest;
import io.github.kaposke.models.DocResponse;
import io.github.kaposke.models.OrgMemberResponse;
import io.github.kaposke.models.SdkResponse;
import io.github.kaposke.models.UpdateApiRequest;
import io.github.kaposke.services.BaseService;
import java.io.IOException;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class ApiService
extends BaseService
implements ApiClient {
    public ApiService(OkHttpClient httpClient) {
        super(httpClient);
    }

    @Override
    public List<ApiResponse> getApis(float orgId) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("apis").addQueryParameter("orgId", ParameterConverter.toQueryParameterValue(Float.valueOf(orgId))).build().toString();
        Request request = new Request.Builder().url(url).get().build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<List<ApiResponse>>(){});
    }

    @Override
    public ApiResponse create(CreateApiRequest input) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("apis").build().toString();
        RequestBody requestBody = RequestBody.create((String)ModelConverter.modelToJson(input), (MediaType)MediaType.parse((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).post(requestBody).build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<ApiResponse>(){});
    }

    @Override
    public ApiResponse getById(float id) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("apis").addPathSegment(String.valueOf(id)).build().toString();
        Request request = new Request.Builder().url(url).get().build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<ApiResponse>(){});
    }

    @Override
    public ApiResponse update(UpdateApiRequest input, float id) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("apis").addPathSegment(String.valueOf(id)).build().toString();
        RequestBody requestBody = RequestBody.create((String)ModelConverter.modelToJson(input), (MediaType)MediaType.parse((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).patch(requestBody).build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<ApiResponse>(){});
    }

    @Override
    public String remove(float id) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("apis").addPathSegment(String.valueOf(id)).build().toString();
        Request request = new Request.Builder().url(url).delete().build();
        Response response = this.execute(request);
        try {
            return response.body().string();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<OrgMemberResponse> getApiMembers(float id) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("apis").addPathSegment(String.valueOf(id)).addPathSegment("members").build().toString();
        Request request = new Request.Builder().url(url).get().build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<List<OrgMemberResponse>>(){});
    }

    @Override
    public List<SdkResponse> getApiSdks(float id) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("apis").addPathSegment(String.valueOf(id)).addPathSegment("sdks").build().toString();
        Request request = new Request.Builder().url(url).get().build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<List<SdkResponse>>(){});
    }

    @Override
    public List<DocResponse> getApiDocs(float id) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("apis").addPathSegment(String.valueOf(id)).addPathSegment("docs").build().toString();
        Request request = new Request.Builder().url(url).get().build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<List<DocResponse>>(){});
    }

    @Override
    public List<BuildResponse> getApiBuilds(float id) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("apis").addPathSegment(String.valueOf(id)).addPathSegment("builds").build().toString();
        Request request = new Request.Builder().url(url).get().build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<List<BuildResponse>>(){});
    }

    @Override
    public List<ApiResponse> getApiByOrgSlugAndApiSlug(String orgSlug, String apiSlug) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("apis").addPathSegment(String.valueOf(orgSlug)).addPathSegment(String.valueOf(apiSlug)).build().toString();
        Request request = new Request.Builder().url(url).get().build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<List<ApiResponse>>(){});
    }
}

