package io.github.kaposke.models;

@lombok.Getter
@lombok.EqualsAndHashCode(callSuper = false)
@lombok.ToString
@com.fasterxml.jackson.annotation.JsonInclude(
  com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL
)
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = SdkResponse.Builder.class)
public class SdkResponse extends io.github.kaposke.models.BaseModel {

  @lombok.Getter
  @lombok.Setter
  @lombok.experimental.Accessors(chain = true)
  @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(
    buildMethodName = "buildWithoutValidation",
    withPrefix = "set"
  )
  public static class Builder extends io.github.kaposke.models.BaseModel.Builder {

    static final java.util.Set<java.util.Set<String>> REQUIRED_FIELDS_GROUPS;

    static {
      java.lang.String[][] requiredFieldsGroups = new java.lang.String[][] {
        new java.lang.String[] {
          "artifactId",
          "createdAt",
          "fileLocation",
          "id",
          "language",
          "updatedAt",
          "version",
        },
      };

      REQUIRED_FIELDS_GROUPS =
        java.util.Arrays
          .stream(requiredFieldsGroups)
          .map(group -> java.util.Arrays.stream(group).collect(java.util.stream.Collectors.toSet()))
          .collect(java.util.stream.Collectors.toSet());
    }

    @com.fasterxml.jackson.annotation.JsonProperty("artifactId")
    private java.lang.Double artifactId;

    @com.fasterxml.jackson.annotation.JsonProperty("createdAt")
    private java.lang.String createdAt;

    @com.fasterxml.jackson.annotation.JsonProperty("fileLocation")
    private java.lang.String fileLocation;

    @com.fasterxml.jackson.annotation.JsonProperty("id")
    private java.lang.Double id;

    @com.fasterxml.jackson.annotation.JsonProperty("language")
    private java.lang.String language;

    @com.fasterxml.jackson.annotation.JsonProperty("updatedAt")
    private java.lang.String updatedAt;

    @com.fasterxml.jackson.annotation.JsonProperty("version")
    private java.lang.String version;

    public Builder() {
      super(ValidationType.ALL_OF);
    }

    protected Builder(BaseModel.Builder.ValidationType validationType) {
      super(validationType);
    }

    public SdkResponse build() {
      String validateMsg = validate();

      if (validateMsg != null) {
        throw new io.github.kaposke.exceptions.ApiException(validateMsg);
      }

      return buildWithoutValidation();
    }

    public SdkResponse buildWithoutValidation() {
      return new SdkResponse(this);
    }

    @Override
    protected java.util.Set<String> getNonNullInstanceFieldNames() {
      // Introspect the class to get a list of all declared fields.
      return java.util.Arrays
        .stream(this.getClass().getDeclaredFields())
        .filter(field -> {
          try {
            // Filter fields that are non-static and have values that are not null.
            return (
              !java.lang.reflect.Modifier.isStatic(field.getModifiers()) && field.get(this) != null
            );
          } catch (IllegalArgumentException | IllegalAccessException e) {
            // This should never happen...

            throw new io.github.kaposke.exceptions.ApiException(
              "Unexpected exception thrown while accessing instance fields.",
              e
            );
          }
        })
        .map(java.lang.reflect.Field::getName)
        .collect(java.util.stream.Collectors.toSet());
    }

    @Override
    protected java.util.Set<java.util.Set<String>> getRequiredFieldsGroups() {
      return REQUIRED_FIELDS_GROUPS;
    }
  }

  @com.fasterxml.jackson.annotation.JsonProperty("artifactId")
  private final java.lang.Double artifactId;

  @com.fasterxml.jackson.annotation.JsonProperty("createdAt")
  private final java.lang.String createdAt;

  @com.fasterxml.jackson.annotation.JsonProperty("fileLocation")
  private final java.lang.String fileLocation;

  @com.fasterxml.jackson.annotation.JsonProperty("id")
  private final java.lang.Double id;

  @com.fasterxml.jackson.annotation.JsonProperty("language")
  private final java.lang.String language;

  @com.fasterxml.jackson.annotation.JsonProperty("updatedAt")
  private final java.lang.String updatedAt;

  @com.fasterxml.jackson.annotation.JsonProperty("version")
  private final java.lang.String version;

  SdkResponse(Builder builder) {
    super(builder);
    this.artifactId = builder.getArtifactId();
    this.createdAt = builder.getCreatedAt();
    this.fileLocation = builder.getFileLocation();
    this.id = builder.getId();
    this.language = builder.getLanguage();
    this.updatedAt = builder.getUpdatedAt();
    this.version = builder.getVersion();
  }
}
