package io.github.kaposke.services;

import static io.github.kaposke.http.ParameterConverter.toQueryParameterValue;

import io.github.kaposke.Configuration;
import io.github.kaposke.exceptions.ApiException;
import io.github.kaposke.http.*;
import io.github.kaposke.models.BaseModel;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class ApiService extends BaseService implements ApiClient {

  public ApiService(OkHttpClient httpClient) {
    super(httpClient);
  }

  public java.util.List<io.github.kaposke.models.ApiResponse> getApis(float orgId)
    throws ApiException {
    String url = HttpUrl
      .parse(Configuration.SERVER_URL)
      .newBuilder()
      .addPathSegment("apis")
      .addQueryParameter("orgId", toQueryParameterValue(orgId))
      .build()
      .toString();
    Request request = new Request.Builder().url(url).get().build();
    Response response = this.execute(request);

    return ModelConverter.convert(
      response,
      new com.fasterxml.jackson.core.type.TypeReference<java.util.List<io.github.kaposke.models.ApiResponse>>() {}
    );
  }

  public io.github.kaposke.models.ApiResponse create(
    io.github.kaposke.models.CreateApiRequest input
  ) throws ApiException {
    String url = HttpUrl
      .parse(Configuration.SERVER_URL)
      .newBuilder()
      .addPathSegment("apis")
      .build()
      .toString();
    RequestBody requestBody = RequestBody.create(
      ModelConverter.modelToJson(input),
      okhttp3.MediaType.parse("application/json; charset=utf-8")
    );
    Request request = new Request.Builder().url(url).post(requestBody).build();
    Response response = this.execute(request);

    return ModelConverter.convert(
      response,
      new com.fasterxml.jackson.core.type.TypeReference<io.github.kaposke.models.ApiResponse>() {}
    );
  }

  public io.github.kaposke.models.ApiResponse getById(float id) throws ApiException {
    String url = HttpUrl
      .parse(Configuration.SERVER_URL)
      .newBuilder()
      .addPathSegment("apis")
      .addPathSegment(String.valueOf(id))
      .build()
      .toString();
    Request request = new Request.Builder().url(url).get().build();
    Response response = this.execute(request);

    return ModelConverter.convert(
      response,
      new com.fasterxml.jackson.core.type.TypeReference<io.github.kaposke.models.ApiResponse>() {}
    );
  }

  public io.github.kaposke.models.ApiResponse update(
    io.github.kaposke.models.UpdateApiRequest input,
    float id
  ) throws ApiException {
    String url = HttpUrl
      .parse(Configuration.SERVER_URL)
      .newBuilder()
      .addPathSegment("apis")
      .addPathSegment(String.valueOf(id))
      .build()
      .toString();
    RequestBody requestBody = RequestBody.create(
      ModelConverter.modelToJson(input),
      okhttp3.MediaType.parse("application/json; charset=utf-8")
    );
    Request request = new Request.Builder().url(url).patch(requestBody).build();
    Response response = this.execute(request);

    return ModelConverter.convert(
      response,
      new com.fasterxml.jackson.core.type.TypeReference<io.github.kaposke.models.ApiResponse>() {}
    );
  }

  public String remove(float id) throws ApiException {
    String url = HttpUrl
      .parse(Configuration.SERVER_URL)
      .newBuilder()
      .addPathSegment("apis")
      .addPathSegment(String.valueOf(id))
      .build()
      .toString();
    Request request = new Request.Builder().url(url).delete().build();
    Response response = this.execute(request);

    try {
      return response.body().string();
    } catch (IOException e) {
      e.printStackTrace();
    }
    return null;
  }

  public java.util.List<io.github.kaposke.models.OrgMemberResponse> getApiMembers(float id)
    throws ApiException {
    String url = HttpUrl
      .parse(Configuration.SERVER_URL)
      .newBuilder()
      .addPathSegment("apis")
      .addPathSegment(String.valueOf(id))
      .addPathSegment("members")
      .build()
      .toString();
    Request request = new Request.Builder().url(url).get().build();
    Response response = this.execute(request);

    return ModelConverter.convert(
      response,
      new com.fasterxml.jackson.core.type.TypeReference<java.util.List<io.github.kaposke.models.OrgMemberResponse>>() {}
    );
  }

  public java.util.List<io.github.kaposke.models.SdkResponse> getApiSdks(float id)
    throws ApiException {
    String url = HttpUrl
      .parse(Configuration.SERVER_URL)
      .newBuilder()
      .addPathSegment("apis")
      .addPathSegment(String.valueOf(id))
      .addPathSegment("sdks")
      .build()
      .toString();
    Request request = new Request.Builder().url(url).get().build();
    Response response = this.execute(request);

    return ModelConverter.convert(
      response,
      new com.fasterxml.jackson.core.type.TypeReference<java.util.List<io.github.kaposke.models.SdkResponse>>() {}
    );
  }

  public java.util.List<io.github.kaposke.models.DocResponse> getApiDocs(float id)
    throws ApiException {
    String url = HttpUrl
      .parse(Configuration.SERVER_URL)
      .newBuilder()
      .addPathSegment("apis")
      .addPathSegment(String.valueOf(id))
      .addPathSegment("docs")
      .build()
      .toString();
    Request request = new Request.Builder().url(url).get().build();
    Response response = this.execute(request);

    return ModelConverter.convert(
      response,
      new com.fasterxml.jackson.core.type.TypeReference<java.util.List<io.github.kaposke.models.DocResponse>>() {}
    );
  }

  public java.util.List<io.github.kaposke.models.BuildResponse> getApiBuilds(float id)
    throws ApiException {
    String url = HttpUrl
      .parse(Configuration.SERVER_URL)
      .newBuilder()
      .addPathSegment("apis")
      .addPathSegment(String.valueOf(id))
      .addPathSegment("builds")
      .build()
      .toString();
    Request request = new Request.Builder().url(url).get().build();
    Response response = this.execute(request);

    return ModelConverter.convert(
      response,
      new com.fasterxml.jackson.core.type.TypeReference<java.util.List<io.github.kaposke.models.BuildResponse>>() {}
    );
  }

  public java.util.List<io.github.kaposke.models.ApiResponse> getApiByOrgSlugAndApiSlug(
    String orgSlug,
    String apiSlug
  ) throws ApiException {
    String url = HttpUrl
      .parse(Configuration.SERVER_URL)
      .newBuilder()
      .addPathSegment("apis")
      .addPathSegment(String.valueOf(orgSlug))
      .addPathSegment(String.valueOf(apiSlug))
      .build()
      .toString();
    Request request = new Request.Builder().url(url).get().build();
    Response response = this.execute(request);

    return ModelConverter.convert(
      response,
      new com.fasterxml.jackson.core.type.TypeReference<java.util.List<io.github.kaposke.models.ApiResponse>>() {}
    );
  }
}
