package io.github.kaposke.services;

import static io.github.kaposke.http.ParameterConverter.toQueryParameterValue;

import io.github.kaposke.Configuration;
import io.github.kaposke.exceptions.ApiException;
import io.github.kaposke.http.*;
import io.github.kaposke.models.BaseModel;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class DocService extends BaseService implements DocClient {

  public DocService(OkHttpClient httpClient) {
    super(httpClient);
  }

  public io.github.kaposke.models.DocResponse getApprovedByOrgSlugAndApiSlug(
    String orgSlug,
    String apiSlug,
    String apiVersion
  ) throws ApiException {
    String url = HttpUrl
      .parse(Configuration.SERVER_URL)
      .newBuilder()
      .addPathSegment("docs")
      .addPathSegment("approved")
      .addQueryParameter("orgSlug", toQueryParameterValue(orgSlug))
      .addQueryParameter("apiSlug", toQueryParameterValue(apiSlug))
      .addQueryParameter("apiVersion", toQueryParameterValue(apiVersion))
      .build()
      .toString();
    Request request = new Request.Builder().url(url).get().build();
    Response response = this.execute(request);

    return ModelConverter.convert(
      response,
      new com.fasterxml.jackson.core.type.TypeReference<io.github.kaposke.models.DocResponse>() {}
    );
  }

  public java.util.List<io.github.kaposke.models.DocResponse> getAllApprovedByOrgSlugAndApiSlug(
    String orgSlug,
    String apiSlug,
    String apiVersion
  ) throws ApiException {
    String url = HttpUrl
      .parse(Configuration.SERVER_URL)
      .newBuilder()
      .addPathSegment("docs")
      .addPathSegment("approved")
      .addPathSegment("all")
      .addQueryParameter("orgSlug", toQueryParameterValue(orgSlug))
      .addQueryParameter("apiSlug", toQueryParameterValue(apiSlug))
      .addQueryParameter("apiVersion", toQueryParameterValue(apiVersion))
      .build()
      .toString();
    Request request = new Request.Builder().url(url).get().build();
    Response response = this.execute(request);

    return ModelConverter.convert(
      response,
      new com.fasterxml.jackson.core.type.TypeReference<java.util.List<io.github.kaposke.models.DocResponse>>() {}
    );
  }

  public java.util.List<io.github.kaposke.models.DocResponse> findDocs(
    float offset,
    float limit,
    float artifactId
  ) throws ApiException {
    String url = HttpUrl
      .parse(Configuration.SERVER_URL)
      .newBuilder()
      .addPathSegment("docs")
      .addQueryParameter("offset", toQueryParameterValue(offset))
      .addQueryParameter("limit", toQueryParameterValue(limit))
      .addQueryParameter("artifactId", toQueryParameterValue(artifactId))
      .build()
      .toString();
    Request request = new Request.Builder().url(url).get().build();
    Response response = this.execute(request);

    return ModelConverter.convert(
      response,
      new com.fasterxml.jackson.core.type.TypeReference<java.util.List<io.github.kaposke.models.DocResponse>>() {}
    );
  }

  public io.github.kaposke.models.DocCreatedResponse create(
    io.github.kaposke.models.CreateDocRequest input
  ) throws ApiException {
    String url = HttpUrl
      .parse(Configuration.SERVER_URL)
      .newBuilder()
      .addPathSegment("docs")
      .build()
      .toString();
    RequestBody requestBody = RequestBody.create(
      ModelConverter.modelToJson(input),
      okhttp3.MediaType.parse("application/json; charset=utf-8")
    );
    Request request = new Request.Builder().url(url).post(requestBody).build();
    Response response = this.execute(request);

    return ModelConverter.convert(
      response,
      new com.fasterxml.jackson.core.type.TypeReference<io.github.kaposke.models.DocCreatedResponse>() {}
    );
  }

  public io.github.kaposke.models.DocResponse approve(String previewSlug) throws ApiException {
    String url = HttpUrl
      .parse(Configuration.SERVER_URL)
      .newBuilder()
      .addPathSegment("docs")
      .addPathSegment(String.valueOf(previewSlug))
      .addPathSegment("approve")
      .build()
      .toString();
    RequestBody requestBody = RequestBody.create(
      ModelConverter.modelToJson(new BaseModel() {}),
      okhttp3.MediaType.parse("application/json; charset=utf-8")
    );
    Request request = new Request.Builder().url(url).post(requestBody).build();
    Response response = this.execute(request);

    return ModelConverter.convert(
      response,
      new com.fasterxml.jackson.core.type.TypeReference<io.github.kaposke.models.DocResponse>() {}
    );
  }

  public io.github.kaposke.models.DocResponse getById(float id) throws ApiException {
    String url = HttpUrl
      .parse(Configuration.SERVER_URL)
      .newBuilder()
      .addPathSegment("docs")
      .addPathSegment(String.valueOf(id))
      .build()
      .toString();
    Request request = new Request.Builder().url(url).get().build();
    Response response = this.execute(request);

    return ModelConverter.convert(
      response,
      new com.fasterxml.jackson.core.type.TypeReference<io.github.kaposke.models.DocResponse>() {}
    );
  }

  public io.github.kaposke.models.DocResponse update(
    io.github.kaposke.models.UpdateDocRequest input,
    float id
  ) throws ApiException {
    String url = HttpUrl
      .parse(Configuration.SERVER_URL)
      .newBuilder()
      .addPathSegment("docs")
      .addPathSegment(String.valueOf(id))
      .build()
      .toString();
    RequestBody requestBody = RequestBody.create(
      ModelConverter.modelToJson(input),
      okhttp3.MediaType.parse("application/json; charset=utf-8")
    );
    Request request = new Request.Builder().url(url).put(requestBody).build();
    Response response = this.execute(request);

    return ModelConverter.convert(
      response,
      new com.fasterxml.jackson.core.type.TypeReference<io.github.kaposke.models.DocResponse>() {}
    );
  }

  public io.github.kaposke.models.DocResponse remove(float id) throws ApiException {
    String url = HttpUrl
      .parse(Configuration.SERVER_URL)
      .newBuilder()
      .addPathSegment("docs")
      .addPathSegment(String.valueOf(id))
      .build()
      .toString();
    Request request = new Request.Builder().url(url).delete().build();
    Response response = this.execute(request);

    return ModelConverter.convert(
      response,
      new com.fasterxml.jackson.core.type.TypeReference<io.github.kaposke.models.DocResponse>() {}
    );
  }
}
