/*
 * Decompiled with CFR 0.152.
 */
package io.github.kaposke.models;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.github.kaposke.exceptions.ApiException;
import io.github.kaposke.models.BaseModel;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=Builder.class)
public class BuildDocRequest
extends BaseModel {
    @JsonProperty(value="apiId")
    private final Double apiId;
    @JsonProperty(value="openApiUrl")
    private final String openApiUrl;

    BuildDocRequest(Builder builder) {
        super(builder);
        this.apiId = builder.getApiId();
        this.openApiUrl = builder.getOpenApiUrl();
    }

    public Double getApiId() {
        return this.apiId;
    }

    public String getOpenApiUrl() {
        return this.openApiUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildDocRequest)) {
            return false;
        }
        BuildDocRequest other = (BuildDocRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$apiId = this.getApiId();
        Double other$apiId = other.getApiId();
        if (this$apiId == null ? other$apiId != null : !((Object)this$apiId).equals(other$apiId)) {
            return false;
        }
        String this$openApiUrl = this.getOpenApiUrl();
        String other$openApiUrl = other.getOpenApiUrl();
        return !(this$openApiUrl == null ? other$openApiUrl != null : !this$openApiUrl.equals(other$openApiUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BuildDocRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $apiId = this.getApiId();
        result = result * 59 + ($apiId == null ? 43 : ((Object)$apiId).hashCode());
        String $openApiUrl = this.getOpenApiUrl();
        result = result * 59 + ($openApiUrl == null ? 43 : $openApiUrl.hashCode());
        return result;
    }

    public String toString() {
        return "BuildDocRequest(apiId=" + this.getApiId() + ", openApiUrl=" + this.getOpenApiUrl() + ")";
    }

    @JsonPOJOBuilder(buildMethodName="buildWithoutValidation", withPrefix="set")
    public static class Builder
    extends BaseModel.Builder {
        static final Set<Set<String>> REQUIRED_FIELDS_GROUPS;
        @JsonProperty(value="apiId")
        private Double apiId;
        @JsonProperty(value="openApiUrl")
        private String openApiUrl;

        public Builder() {
            super(BaseModel.Builder.ValidationType.ALL_OF);
        }

        protected Builder(BaseModel.Builder.ValidationType validationType) {
            super(validationType);
        }

        public BuildDocRequest build() {
            String validateMsg = this.validate();
            if (validateMsg != null) {
                throw new ApiException(validateMsg);
            }
            return this.buildWithoutValidation();
        }

        public BuildDocRequest buildWithoutValidation() {
            return new BuildDocRequest(this);
        }

        @Override
        protected Set<String> getNonNullInstanceFieldNames() {
            return Arrays.stream(this.getClass().getDeclaredFields()).filter(field -> {
                try {
                    return !Modifier.isStatic(field.getModifiers()) && field.get(this) != null;
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new ApiException("Unexpected exception thrown while accessing instance fields.", e);
                }
            }).map(Field::getName).collect(Collectors.toSet());
        }

        @Override
        protected Set<Set<String>> getRequiredFieldsGroups() {
            return REQUIRED_FIELDS_GROUPS;
        }

        public Double getApiId() {
            return this.apiId;
        }

        public String getOpenApiUrl() {
            return this.openApiUrl;
        }

        @JsonProperty(value="apiId")
        public Builder setApiId(Double apiId) {
            this.apiId = apiId;
            return this;
        }

        @JsonProperty(value="openApiUrl")
        public Builder setOpenApiUrl(String openApiUrl) {
            this.openApiUrl = openApiUrl;
            return this;
        }

        static {
            String[][] requiredFieldsGroups = new String[][]{{"apiId", "openApiUrl"}};
            REQUIRED_FIELDS_GROUPS = Arrays.stream(requiredFieldsGroups).map(group -> Arrays.stream(group).collect(Collectors.toSet())).collect(Collectors.toSet());
        }
    }
}

