/*
 * Decompiled with CFR 0.152.
 */
package io.github.kaposke.services;

import com.fasterxml.jackson.core.type.TypeReference;
import io.github.kaposke.exceptions.ApiException;
import io.github.kaposke.http.ArtifactClient;
import io.github.kaposke.http.ModelConverter;
import io.github.kaposke.http.ParameterConverter;
import io.github.kaposke.models.ApiResponse;
import io.github.kaposke.models.ArtifactResponse;
import io.github.kaposke.models.CreateArtifactRequest;
import io.github.kaposke.services.BaseService;
import java.io.IOException;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class ArtifactService
extends BaseService
implements ArtifactClient {
    public ArtifactService(OkHttpClient httpClient) {
        super(httpClient);
    }

    @Override
    public List<ApiResponse> getArtifacts(float buildId) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("artifacts").addQueryParameter("buildId", ParameterConverter.toQueryParameterValue(Float.valueOf(buildId))).build().toString();
        Request request = new Request.Builder().url(url).get().build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<List<ApiResponse>>(){});
    }

    @Override
    public ArtifactResponse create(CreateArtifactRequest input) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("artifacts").build().toString();
        RequestBody requestBody = RequestBody.create((String)ModelConverter.modelToJson(input), (MediaType)MediaType.parse((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).post(requestBody).build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<ArtifactResponse>(){});
    }

    @Override
    public ApiResponse getById(float id) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("artifacts").addPathSegment(String.valueOf(id)).build().toString();
        Request request = new Request.Builder().url(url).get().build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<ApiResponse>(){});
    }

    @Override
    public String remove(float id) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("artifacts").addPathSegment(String.valueOf(id)).build().toString();
        Request request = new Request.Builder().url(url).delete().build();
        Response response = this.execute(request);
        try {
            return response.body().string();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

