/*
 * Decompiled with CFR 0.152.
 */
package io.github.kaposke.services;

import com.fasterxml.jackson.core.type.TypeReference;
import io.github.kaposke.exceptions.ApiException;
import io.github.kaposke.http.ModelConverter;
import io.github.kaposke.http.OrgMemberClient;
import io.github.kaposke.models.BaseModel;
import io.github.kaposke.models.CreateOrgMemberRequest;
import io.github.kaposke.models.OrgMemberResponse;
import io.github.kaposke.models.UpdateManyOrgMembersResponse;
import io.github.kaposke.models.UpdateOrgMemberRequest;
import io.github.kaposke.services.BaseService;
import java.io.IOException;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OrgMemberService
extends BaseService
implements OrgMemberClient {
    public OrgMemberService(OkHttpClient httpClient) {
        super(httpClient);
    }

    @Override
    public List<OrgMemberResponse> getByOrgId(float orgId) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("orgs").addPathSegment(String.valueOf(orgId)).addPathSegment("members").build().toString();
        Request request = new Request.Builder().url(url).get().build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<List<OrgMemberResponse>>(){});
    }

    @Override
    public OrgMemberResponse createMember(CreateOrgMemberRequest input, float orgId) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("orgs").addPathSegment(String.valueOf(orgId)).addPathSegment("members").build().toString();
        RequestBody requestBody = RequestBody.create((String)ModelConverter.modelToJson(input), (MediaType)MediaType.parse((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).post(requestBody).build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<OrgMemberResponse>(){});
    }

    @Override
    public OrgMemberResponse updateMember(UpdateOrgMemberRequest input, float memberId, float orgId) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("orgs").addPathSegment(String.valueOf(orgId)).addPathSegment("members").addPathSegment(String.valueOf(memberId)).build().toString();
        RequestBody requestBody = RequestBody.create((String)ModelConverter.modelToJson(input), (MediaType)MediaType.parse((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).patch(requestBody).build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<OrgMemberResponse>(){});
    }

    @Override
    public String removeMember(float memberId, float orgId) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("orgs").addPathSegment(String.valueOf(orgId)).addPathSegment("members").addPathSegment(String.valueOf(memberId)).build().toString();
        Request request = new Request.Builder().url(url).delete().build();
        Response response = this.execute(request);
        try {
            return response.body().string();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public UpdateManyOrgMembersResponse enableAllMembers(float orgId) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("orgs").addPathSegment(String.valueOf(orgId)).addPathSegment("enable").build().toString();
        RequestBody requestBody = RequestBody.create((String)ModelConverter.modelToJson(new BaseModel(){}), (MediaType)MediaType.parse((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).patch(requestBody).build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<UpdateManyOrgMembersResponse>(){});
    }

    @Override
    public UpdateManyOrgMembersResponse disableAllMembers(float orgId) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("orgs").addPathSegment(String.valueOf(orgId)).addPathSegment("disable").build().toString();
        RequestBody requestBody = RequestBody.create((String)ModelConverter.modelToJson(new BaseModel(){}), (MediaType)MediaType.parse((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).patch(requestBody).build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<UpdateManyOrgMembersResponse>(){});
    }
}

