package io.github.kaposke.models;

@lombok.Getter
@lombok.EqualsAndHashCode(callSuper = false)
@lombok.ToString
@com.fasterxml.jackson.annotation.JsonInclude(
  com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL
)
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = BuildResponse.Builder.class)
public class BuildResponse extends io.github.kaposke.models.BaseModel {

  @lombok.Getter
  @lombok.EqualsAndHashCode(callSuper = false)
  @lombok.ToString
  @com.fasterxml.jackson.annotation.JsonInclude(
    com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL
  )
  @com.fasterxml.jackson.databind.annotation.JsonDeserialize(
    builder = BuildResponse.BuildType.Builder.class
  )
  public static class BuildType extends io.github.kaposke.models.BaseModel {

    @lombok.Getter
    @lombok.Setter
    @lombok.experimental.Accessors(chain = true)
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(
      buildMethodName = "buildWithoutValidation",
      withPrefix = "set"
    )
    public static class Builder extends io.github.kaposke.models.BaseModel.Builder {

      static final java.util.Set<java.util.Set<String>> REQUIRED_FIELDS_GROUPS;

      static {
        java.lang.String[][] requiredFieldsGroups = new java.lang.String[][] {};

        REQUIRED_FIELDS_GROUPS =
          java.util.Arrays
            .stream(requiredFieldsGroups)
            .map(group ->
              java.util.Arrays.stream(group).collect(java.util.stream.Collectors.toSet())
            )
            .collect(java.util.stream.Collectors.toSet());
      }

      public Builder() {
        super(ValidationType.ALL_OF);
      }

      protected Builder(BaseModel.Builder.ValidationType validationType) {
        super(validationType);
      }

      public BuildResponse.BuildType build() {
        String validateMsg = validate();

        if (validateMsg != null) {
          throw new io.github.kaposke.exceptions.ApiException(validateMsg);
        }

        return buildWithoutValidation();
      }

      public BuildResponse.BuildType buildWithoutValidation() {
        return new BuildResponse.BuildType(this);
      }

      @Override
      protected java.util.Set<String> getNonNullInstanceFieldNames() {
        // Introspect the class to get a list of all declared fields.
        return java.util.Arrays
          .asList(this.getClass().getDeclaredFields())
          .stream()
          .filter(field -> {
            try {
              // Filter fields that are non-static and have values that are not null.
              return (
                !java.lang.reflect.Modifier.isStatic(field.getModifiers()) &&
                field.get(this) != null
              );
            } catch (IllegalArgumentException | IllegalAccessException e) {
              // This should never happen...

              throw new io.github.kaposke.exceptions.ApiException(
                "Unexpected exception thrown while accessing instance fields.",
                e
              );
            }
          })
          .map(java.lang.reflect.Field::getName)
          .collect(java.util.stream.Collectors.toSet());
      }

      @Override
      protected java.util.Set<java.util.Set<String>> getRequiredFieldsGroups() {
        return REQUIRED_FIELDS_GROUPS;
      }
    }

    BuildType(Builder builder) {
      super(builder);
    }
  }

  @lombok.Getter
  @lombok.Setter
  @lombok.experimental.Accessors(chain = true)
  @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(
    buildMethodName = "buildWithoutValidation",
    withPrefix = "set"
  )
  public static class Builder extends io.github.kaposke.models.BaseModel.Builder {

    static final java.util.Set<java.util.Set<String>> REQUIRED_FIELDS_GROUPS;

    static {
      java.lang.String[][] requiredFieldsGroups = new java.lang.String[][] {
        new java.lang.String[] {
          "apiId",
          "buildType",
          "createdAt",
          "endTime",
          "id",
          "startTime",
          "status",
          "updatedAt",
        },
      };

      REQUIRED_FIELDS_GROUPS =
        java.util.Arrays
          .stream(requiredFieldsGroups)
          .map(group -> java.util.Arrays.stream(group).collect(java.util.stream.Collectors.toSet()))
          .collect(java.util.stream.Collectors.toSet());
    }

    @com.fasterxml.jackson.annotation.JsonProperty("apiId")
    private java.lang.Double apiId;

    @com.fasterxml.jackson.annotation.JsonProperty("artifacts")
    private java.util.List<io.github.kaposke.models.ArtifactResponse> artifacts;

    @com.fasterxml.jackson.annotation.JsonProperty("buildType")
    private BuildResponse.BuildType buildType;

    @com.fasterxml.jackson.annotation.JsonProperty("createdAt")
    private java.lang.String createdAt;

    @com.fasterxml.jackson.annotation.JsonProperty("endTime")
    private java.lang.String endTime;

    @com.fasterxml.jackson.annotation.JsonProperty("id")
    private java.lang.Double id;

    @com.fasterxml.jackson.annotation.JsonProperty("startTime")
    private java.lang.String startTime;

    @com.fasterxml.jackson.annotation.JsonProperty("status")
    private java.lang.String status;

    @com.fasterxml.jackson.annotation.JsonProperty("updatedAt")
    private java.lang.String updatedAt;

    public Builder() {
      super(ValidationType.ALL_OF);
    }

    protected Builder(BaseModel.Builder.ValidationType validationType) {
      super(validationType);
    }

    public BuildResponse build() {
      String validateMsg = validate();

      if (validateMsg != null) {
        throw new io.github.kaposke.exceptions.ApiException(validateMsg);
      }

      return buildWithoutValidation();
    }

    public BuildResponse buildWithoutValidation() {
      return new BuildResponse(this);
    }

    @Override
    protected java.util.Set<String> getNonNullInstanceFieldNames() {
      // Introspect the class to get a list of all declared fields.
      return java.util.Arrays
        .stream(this.getClass().getDeclaredFields())
        .filter(field -> {
          try {
            // Filter fields that are non-static and have values that are not null.
            return (
              !java.lang.reflect.Modifier.isStatic(field.getModifiers()) && field.get(this) != null
            );
          } catch (IllegalArgumentException | IllegalAccessException e) {
            // This should never happen...

            throw new io.github.kaposke.exceptions.ApiException(
              "Unexpected exception thrown while accessing instance fields.",
              e
            );
          }
        })
        .map(java.lang.reflect.Field::getName)
        .collect(java.util.stream.Collectors.toSet());
    }

    @Override
    protected java.util.Set<java.util.Set<String>> getRequiredFieldsGroups() {
      return REQUIRED_FIELDS_GROUPS;
    }
  }

  @com.fasterxml.jackson.annotation.JsonProperty("apiId")
  private final java.lang.Double apiId;

  @com.fasterxml.jackson.annotation.JsonProperty("artifacts")
  private final java.util.List<io.github.kaposke.models.ArtifactResponse> artifacts;

  @com.fasterxml.jackson.annotation.JsonProperty("buildType")
  private final BuildResponse.BuildType buildType;

  @com.fasterxml.jackson.annotation.JsonProperty("createdAt")
  private final java.lang.String createdAt;

  @com.fasterxml.jackson.annotation.JsonProperty("endTime")
  private final java.lang.String endTime;

  @com.fasterxml.jackson.annotation.JsonProperty("id")
  private final java.lang.Double id;

  @com.fasterxml.jackson.annotation.JsonProperty("startTime")
  private final java.lang.String startTime;

  @com.fasterxml.jackson.annotation.JsonProperty("status")
  private final java.lang.String status;

  @com.fasterxml.jackson.annotation.JsonProperty("updatedAt")
  private final java.lang.String updatedAt;

  BuildResponse(Builder builder) {
    super(builder);
    this.apiId = builder.getApiId();
    this.artifacts = builder.getArtifacts();
    this.buildType = builder.getBuildType();
    this.createdAt = builder.getCreatedAt();
    this.endTime = builder.getEndTime();
    this.id = builder.getId();
    this.startTime = builder.getStartTime();
    this.status = builder.getStatus();
    this.updatedAt = builder.getUpdatedAt();
  }
}
