/*
 * Decompiled with CFR 0.152.
 */
package io.github.kaposke.http.interceptors;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class DefaultHeadersInterceptor
implements Interceptor {
    private final Map<String, String> defaultHeaders = new HashMap<String, String>();

    public DefaultHeadersInterceptor() {
        this.defaultHeaders.put("User-Agent", "liblab/0.1.0 LltestJavaSdkSDK/0.0.4 java/1.8");
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        return chain.proceed(this.addDefaultHeadersToRequest(chain.request()));
    }

    private Request addDefaultHeadersToRequest(Request request) {
        if (this.defaultHeaders.isEmpty()) {
            return request;
        }
        Request.Builder requestBuilder = request.newBuilder();
        this.defaultHeaders.forEach((arg_0, arg_1) -> ((Request.Builder)requestBuilder).addHeader(arg_0, arg_1));
        return requestBuilder.build();
    }
}

