/*
 * Decompiled with CFR 0.152.
 */
package io.github.kaposke.services;

import com.fasterxml.jackson.core.type.TypeReference;
import io.github.kaposke.exceptions.ApiException;
import io.github.kaposke.http.AuthClient;
import io.github.kaposke.http.ModelConverter;
import io.github.kaposke.models.AuthRequest;
import io.github.kaposke.models.AuthTokenResponse;
import io.github.kaposke.models.BaseModel;
import io.github.kaposke.models.ChangePasswordRequest;
import io.github.kaposke.models.OneTimeLoginRequest;
import io.github.kaposke.models.RefreshTokenRequest;
import io.github.kaposke.models.ResetPasswordRequest;
import io.github.kaposke.models.UserResponse;
import io.github.kaposke.models.VerifyEmailRequest;
import io.github.kaposke.services.BaseService;
import java.io.IOException;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class AuthService
extends BaseService
implements AuthClient {
    public AuthService(OkHttpClient httpClient) {
        super(httpClient);
    }

    @Override
    public UserResponse signup(AuthRequest input) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("auth").addPathSegment("signup").build().toString();
        RequestBody requestBody = RequestBody.create((String)ModelConverter.modelToJson(input), (MediaType)MediaType.parse((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).post(requestBody).build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<UserResponse>(){});
    }

    @Override
    public AuthTokenResponse login(AuthRequest input) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("auth").addPathSegment("login").build().toString();
        RequestBody requestBody = RequestBody.create((String)ModelConverter.modelToJson(input), (MediaType)MediaType.parse((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).post(requestBody).build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<AuthTokenResponse>(){});
    }

    @Override
    public String logout() throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("auth").addPathSegment("logout").build().toString();
        RequestBody requestBody = RequestBody.create((String)ModelConverter.modelToJson(new BaseModel(){}), (MediaType)MediaType.parse((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).post(requestBody).build();
        Response response = this.execute(request);
        try {
            return response.body().string();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public AuthTokenResponse refreshToken(RefreshTokenRequest input) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("auth").addPathSegment("refresh-jwt").build().toString();
        RequestBody requestBody = RequestBody.create((String)ModelConverter.modelToJson(input), (MediaType)MediaType.parse((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).post(requestBody).build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<AuthTokenResponse>(){});
    }

    @Override
    public String resetPassword(ResetPasswordRequest input) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("auth").addPathSegment("reset-password").build().toString();
        RequestBody requestBody = RequestBody.create((String)ModelConverter.modelToJson(input), (MediaType)MediaType.parse((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).post(requestBody).build();
        Response response = this.execute(request);
        try {
            return response.body().string();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public AuthTokenResponse oneTimeLogin(OneTimeLoginRequest input) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("auth").addPathSegment("one-time-login").build().toString();
        RequestBody requestBody = RequestBody.create((String)ModelConverter.modelToJson(input), (MediaType)MediaType.parse((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).post(requestBody).build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<AuthTokenResponse>(){});
    }

    @Override
    public AuthTokenResponse changePassword(ChangePasswordRequest input) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("auth").addPathSegment("change-password").build().toString();
        RequestBody requestBody = RequestBody.create((String)ModelConverter.modelToJson(input), (MediaType)MediaType.parse((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).post(requestBody).build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<AuthTokenResponse>(){});
    }

    @Override
    public String verifyEmail(VerifyEmailRequest input) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("auth").addPathSegment("verify-email").build().toString();
        RequestBody requestBody = RequestBody.create((String)ModelConverter.modelToJson(input), (MediaType)MediaType.parse((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).post(requestBody).build();
        Response response = this.execute(request);
        try {
            return response.body().string();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

