/*
 * Decompiled with CFR 0.152.
 */
package io.github.kaposke.services;

import io.github.kaposke.exceptions.ApiException;
import io.github.kaposke.http.EventClient;
import io.github.kaposke.http.ModelConverter;
import io.github.kaposke.models.TrackEventRequest;
import io.github.kaposke.services.BaseService;
import java.io.IOException;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class EventService
extends BaseService
implements EventClient {
    public EventService(OkHttpClient httpClient) {
        super(httpClient);
    }

    @Override
    public String track(TrackEventRequest input) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("events").build().toString();
        RequestBody requestBody = RequestBody.create((String)ModelConverter.modelToJson(input), (MediaType)MediaType.parse((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).post(requestBody).build();
        Response response = this.execute(request);
        try {
            return response.body().string();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

