/*
 * Decompiled with CFR 0.152.
 */
package io.github.kaposke.services;

import com.fasterxml.jackson.core.type.TypeReference;
import io.github.kaposke.exceptions.ApiException;
import io.github.kaposke.http.ModelConverter;
import io.github.kaposke.http.UserClient;
import io.github.kaposke.models.ApiResponse;
import io.github.kaposke.models.CreateUserRequest;
import io.github.kaposke.models.EditUserRequest;
import io.github.kaposke.models.UserResponse;
import io.github.kaposke.services.BaseService;
import java.io.IOException;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class UserService
extends BaseService
implements UserClient {
    public UserService(OkHttpClient httpClient) {
        super(httpClient);
    }

    @Override
    public UserResponse getCurrentUser() throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("users").addPathSegment("current-user").build().toString();
        Request request = new Request.Builder().url(url).get().build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<UserResponse>(){});
    }

    @Override
    public List<ApiResponse> getUserApis() throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("users").build().toString();
        Request request = new Request.Builder().url(url).get().build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<List<ApiResponse>>(){});
    }

    @Override
    public UserResponse create(CreateUserRequest input) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("users").build().toString();
        RequestBody requestBody = RequestBody.create((String)ModelConverter.modelToJson(input), (MediaType)MediaType.parse((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).post(requestBody).build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<UserResponse>(){});
    }

    @Override
    public UserResponse getById(float id) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("users").addPathSegment(String.valueOf(id)).build().toString();
        Request request = new Request.Builder().url(url).get().build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<UserResponse>(){});
    }

    @Override
    public UserResponse update(EditUserRequest input, float id) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("users").addPathSegment(String.valueOf(id)).build().toString();
        RequestBody requestBody = RequestBody.create((String)ModelConverter.modelToJson(input), (MediaType)MediaType.parse((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).patch(requestBody).build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<UserResponse>(){});
    }

    @Override
    public String remove(float id) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("users").addPathSegment(String.valueOf(id)).build().toString();
        Request request = new Request.Builder().url(url).delete().build();
        Response response = this.execute(request);
        try {
            return response.body().string();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

