package io.github.kaposke.http;

import io.github.kaposke.exceptions.ApiException;
import java.util.List;

public interface AuthClient {
  io.github.kaposke.models.UserResponse signup(io.github.kaposke.models.AuthRequest input)
    throws ApiException;
  io.github.kaposke.models.AuthTokenResponse login(io.github.kaposke.models.AuthRequest input)
    throws ApiException;
  String logout() throws ApiException;
  io.github.kaposke.models.AuthTokenResponse refreshToken(
    io.github.kaposke.models.RefreshTokenRequest input
  ) throws ApiException;
  String resetPassword(io.github.kaposke.models.ResetPasswordRequest input) throws ApiException;
  io.github.kaposke.models.AuthTokenResponse oneTimeLogin(
    io.github.kaposke.models.OneTimeLoginRequest input
  ) throws ApiException;
  io.github.kaposke.models.AuthTokenResponse changePassword(
    io.github.kaposke.models.ChangePasswordRequest input
  ) throws ApiException;
  String verifyEmail(io.github.kaposke.models.VerifyEmailRequest input) throws ApiException;
  String resendVerifictionEmail(io.github.kaposke.models.SendVerifyEmailRequest input)
    throws ApiException;
}
