/*
 * Decompiled with CFR 0.152.
 */
package io.github.kaposke;

import io.github.kaposke.http.interceptors.DefaultHeadersInterceptor;
import io.github.kaposke.http.interceptors.RefreshTokenInterceptor;
import io.github.kaposke.http.interceptors.RetryInterceptor;
import io.github.kaposke.services.ApiService;
import io.github.kaposke.services.ArtifactService;
import io.github.kaposke.services.AuthService;
import io.github.kaposke.services.BuildService;
import io.github.kaposke.services.DocService;
import io.github.kaposke.services.EventService;
import io.github.kaposke.services.HealthCheckService;
import io.github.kaposke.services.OrgMemberService;
import io.github.kaposke.services.OrgService;
import io.github.kaposke.services.SdkService;
import io.github.kaposke.services.TokenService;
import io.github.kaposke.services.UserService;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class LLTestJavaSDK {
    public BuildService buildService;
    public ApiService apiService;
    public OrgService orgService;
    public ArtifactService artifactService;
    public SdkService sdkService;
    public DocService docService;
    public OrgMemberService orgmemberService;
    public AuthService authService;
    public UserService userService;
    public TokenService tokenService;
    public HealthCheckService healthcheckService;
    public EventService eventService;
    private final RefreshTokenInterceptor refreshTokenInterceptor = new RefreshTokenInterceptor("https://api-dev.liblab.com/auth/refresh-jwt", "refreshToken", "accessToken", "refreshToken");

    public LLTestJavaSDK() {
        OkHttpClient httpClient = new OkHttpClient.Builder().addInterceptor((Interceptor)new DefaultHeadersInterceptor()).addInterceptor((Interceptor)new RetryInterceptor()).addInterceptor((Interceptor)this.refreshTokenInterceptor).build();
        this.buildService = new BuildService(httpClient);
        this.apiService = new ApiService(httpClient);
        this.orgService = new OrgService(httpClient);
        this.artifactService = new ArtifactService(httpClient);
        this.sdkService = new SdkService(httpClient);
        this.docService = new DocService(httpClient);
        this.orgmemberService = new OrgMemberService(httpClient);
        this.authService = new AuthService(httpClient);
        this.userService = new UserService(httpClient);
        this.tokenService = new TokenService(httpClient);
        this.healthcheckService = new HealthCheckService(httpClient);
        this.eventService = new EventService(httpClient);
    }

    public LLTestJavaSDK(String refreshToken, String bearerToken) {
        this();
        this.setRefreshToken(refreshToken);
        this.setBearerToken(bearerToken);
    }

    public void setRefreshToken(String token) {
        this.refreshTokenInterceptor.setRefreshToken(token);
    }

    public void setBearerToken(String token) {
        this.refreshTokenInterceptor.setBearerToken(token);
    }
}

