/*
 * Decompiled with CFR 0.152.
 */
package io.github.kaposke.exceptions;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ApiException
extends RuntimeException {
    private static final Map<Integer, String> ERROR_MAP = Collections.unmodifiableMap(new HashMap<Integer, String>(){
        {
            this.put(401, "Unauthorized");
            this.put(403, "Forbidden");
            this.put(404, "Not Found");
            this.put(405, "Method Not Allowed");
            this.put(406, "Not Acceptable");
            this.put(409, "Conflict");
            this.put(410, "Gone");
            this.put(500, "Internal Server Error");
            this.put(502, "Bad Gateway");
            this.put(503, "Service Unavailable");
            this.put(504, "Gateway Timeout");
        }
    });
    private final int statusCode;

    public ApiException(int code) {
        super(ApiException.getExceptionMessage(code));
        this.statusCode = code;
    }

    public ApiException(String message) {
        super(message);
        this.statusCode = 0;
    }

    public ApiException(String message, Throwable t) {
        super(message, t);
        this.statusCode = 0;
    }

    public ApiException(int code, String message) {
        super(message);
        this.statusCode = code;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    static String getExceptionMessage(int code) {
        return ERROR_MAP.getOrDefault(code, "Unknown Error");
    }
}

