/*
 * Decompiled with CFR 0.152.
 */
package io.github.kaposke.http.interceptors;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class RefreshTokenInterceptor
implements Interceptor {
    private final String endpoint;
    private final String refreshInputKey;
    private final String bearerKey;
    private final String refreshKey;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private String bearerToken;
    private String refreshToken;

    public RefreshTokenInterceptor(String endpoint, String refreshInputKey, String bearerKey, String refreshKey) {
        if (endpoint == null || endpoint.trim().isEmpty()) {
            throw new IllegalArgumentException("Endpoint is null or blank.");
        }
        if (refreshInputKey == null || refreshInputKey.trim().isEmpty()) {
            throw new IllegalArgumentException("Refresh input key is null or blank.");
        }
        if (bearerKey == null || bearerKey.trim().isEmpty()) {
            throw new IllegalArgumentException("Bearer key is null or blank.");
        }
        this.endpoint = endpoint;
        this.refreshInputKey = refreshInputKey;
        this.bearerKey = bearerKey;
        this.refreshKey = refreshKey;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response = chain.proceed(this.addBearerTokenToRequest(chain.request()));
        if (response.code() != 401 || this.refreshToken == null || this.refreshToken.isEmpty()) {
            return response;
        }
        response.close();
        if (!this.updateAuthTokens(chain)) {
            return response;
        }
        return chain.proceed(this.addBearerTokenToRequest(chain.request()));
    }

    Request addBearerTokenToRequest(Request request) {
        return this.bearerToken != null && !this.bearerToken.isEmpty() ? request.newBuilder().addHeader("Authorization", "Bearer " + this.bearerToken).build() : request;
    }

    private boolean updateAuthTokens(Interceptor.Chain chain) throws IOException {
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put(this.refreshInputKey, this.refreshToken);
        Response response = chain.proceed(chain.request().newBuilder().url(this.endpoint).post(RequestBody.create((String)this.objectMapper.writeValueAsString(requestMap), (MediaType)MediaType.parse((String)"application/json; charset=utf-8"))).build());
        if (!response.isSuccessful()) {
            return false;
        }
        Map responseMap = (Map)this.objectMapper.readValue(response.body().string(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        if (this.refreshKey != null && responseMap.get(this.refreshKey) instanceof String) {
            this.refreshToken = (String)responseMap.get(this.refreshKey);
        }
        if (this.bearerKey != null && responseMap.get(this.bearerKey) instanceof String) {
            this.bearerToken = (String)responseMap.get(this.bearerKey);
        }
        return true;
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    public void setBearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }
}

