/*
 * Decompiled with CFR 0.152.
 */
package io.github.kaposke.services;

import com.fasterxml.jackson.core.type.TypeReference;
import io.github.kaposke.exceptions.ApiException;
import io.github.kaposke.http.BuildClient;
import io.github.kaposke.http.ModelConverter;
import io.github.kaposke.http.ParameterConverter;
import io.github.kaposke.models.BuildDocRequest;
import io.github.kaposke.models.BuildResponse;
import io.github.kaposke.models.CreateSdkBuildRequest;
import io.github.kaposke.services.BaseService;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class BuildService
extends BaseService
implements BuildClient {
    public BuildService(OkHttpClient httpClient) {
        super(httpClient);
    }

    @Override
    public BuildResponse buildSdk(CreateSdkBuildRequest input) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("builds").addPathSegment("sdk").build().toString();
        RequestBody requestBody = RequestBody.create((String)ModelConverter.modelToJson(input), (MediaType)MediaType.parse((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).post(requestBody).build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<BuildResponse>(){});
    }

    @Override
    public BuildResponse buildDoc(BuildDocRequest input) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("builds").addPathSegment("doc").build().toString();
        RequestBody requestBody = RequestBody.create((String)ModelConverter.modelToJson(input), (MediaType)MediaType.parse((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).post(requestBody).build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<BuildResponse>(){});
    }

    @Override
    public List<BuildResponse> getBuilds(float apiId) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("builds").addQueryParameter("apiId", ParameterConverter.toQueryParameterValue(Float.valueOf(apiId))).build().toString();
        Request request = new Request.Builder().url(url).get().build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<List<BuildResponse>>(){});
    }

    @Override
    public BuildResponse getById(float id) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("builds").addPathSegment(String.valueOf(id)).build().toString();
        Request request = new Request.Builder().url(url).get().build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<BuildResponse>(){});
    }
}

