/*
 * Decompiled with CFR 0.152.
 */
package io.github.kaposke.services;

import com.fasterxml.jackson.core.type.TypeReference;
import io.github.kaposke.exceptions.ApiException;
import io.github.kaposke.http.ModelConverter;
import io.github.kaposke.http.OrgClient;
import io.github.kaposke.models.ApiResponse;
import io.github.kaposke.models.ArtifactResponse;
import io.github.kaposke.models.CreateOrgRequest;
import io.github.kaposke.models.DocResponse;
import io.github.kaposke.models.EditOrgRequest;
import io.github.kaposke.models.OrgGetPayments200Response;
import io.github.kaposke.models.OrgResponse;
import io.github.kaposke.services.BaseService;
import java.io.IOException;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OrgService
extends BaseService
implements OrgClient {
    public OrgService(OkHttpClient httpClient) {
        super(httpClient);
    }

    @Override
    public List<OrgResponse> getByCurrentUser() throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("orgs").build().toString();
        Request request = new Request.Builder().url(url).get().build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<List<OrgResponse>>(){});
    }

    @Override
    public OrgResponse create(CreateOrgRequest input) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("orgs").build().toString();
        RequestBody requestBody = RequestBody.create((String)ModelConverter.modelToJson(input), (MediaType)MediaType.parse((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).post(requestBody).build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<OrgResponse>(){});
    }

    @Override
    public OrgResponse getById(float id) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("orgs").addPathSegment(String.valueOf(id)).build().toString();
        Request request = new Request.Builder().url(url).get().build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<OrgResponse>(){});
    }

    @Override
    public OrgResponse update(EditOrgRequest input, float id) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("orgs").addPathSegment(String.valueOf(id)).build().toString();
        RequestBody requestBody = RequestBody.create((String)ModelConverter.modelToJson(input), (MediaType)MediaType.parse((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).patch(requestBody).build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<OrgResponse>(){});
    }

    @Override
    public String remove(float id) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("orgs").addPathSegment(String.valueOf(id)).build().toString();
        Request request = new Request.Builder().url(url).delete().build();
        Response response = this.execute(request);
        try {
            return response.body().string();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<ApiResponse> getApis(float id) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("orgs").addPathSegment(String.valueOf(id)).addPathSegment("apis").build().toString();
        Request request = new Request.Builder().url(url).get().build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<List<ApiResponse>>(){});
    }

    @Override
    public OrgGetPayments200Response getPayments(float id) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("orgs").addPathSegment(String.valueOf(id)).addPathSegment("payments").build().toString();
        Request request = new Request.Builder().url(url).get().build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<OrgGetPayments200Response>(){});
    }

    @Override
    public List<ArtifactResponse> getArtifacts(float id) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("orgs").addPathSegment(String.valueOf(id)).addPathSegment("artifacts").build().toString();
        Request request = new Request.Builder().url(url).get().build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<List<ArtifactResponse>>(){});
    }

    @Override
    public List<DocResponse> getDocs(float id) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("orgs").addPathSegment(String.valueOf(id)).addPathSegment("docs").build().toString();
        Request request = new Request.Builder().url(url).get().build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<List<DocResponse>>(){});
    }
}

