/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.ChatImageCode;

import io.github.kituin.ChatImageCode.ChatImageCode;
import io.github.kituin.ChatImageCode.ChatImageHandler;
import io.github.kituin.ChatImageCode.ChatImageHttpHandler;
import io.github.kituin.ChatImageCode.exception.InvalidChatImageUrlException;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;

public class ChatImageUrl {
    private final String originalUrl;
    private String httpUrl;
    private final UrlMethod urlMethod;
    private String fileUrl;
    public static NetworkHelper networkHelper;
    public static CachePathHelper cachePathHelper;

    private static URI loadUri(String url) throws InvalidChatImageUrlException {
        try {
            return new URI(url.replace("\\", "/"));
        }
        catch (URISyntaxException e) {
            throw new InvalidChatImageUrlException(url + "<- this url is invalid, Please Check again", InvalidChatImageUrlException.InvalidUrlMode.NotFound);
        }
    }

    public ChatImageUrl(URI uri) throws InvalidChatImageUrlException {
        this.originalUrl = uri.toString();
        cachePathHelper.check();
        if (Objects.equals(uri.getScheme(), "https") || Objects.equals(uri.getScheme(), "http")) {
            boolean f;
            this.urlMethod = UrlMethod.HTTP;
            this.httpUrl = uri.toString();
            if (!ChatImageCode.CACHE_MAP.containsKey(this.httpUrl) && !(f = ChatImageHttpHandler.getInputStream(this.httpUrl))) {
                throw new InvalidChatImageUrlException("Invalid HTTP URL", InvalidChatImageUrlException.InvalidUrlMode.HttpNotFound);
            }
        } else if (Objects.equals(uri.getScheme(), "file")) {
            this.urlMethod = UrlMethod.FILE;
            this.fileUrl = uri.toString().replace("file:///", "");
            File file = new File(this.fileUrl);
            if (!ChatImageCode.CACHE_MAP.containsKey(this.fileUrl)) {
                boolean fileExist = file.exists();
                if (fileExist) {
                    ChatImageHandler.loadFile(this.fileUrl);
                }
                networkHelper.send(this.fileUrl, file, fileExist);
            }
        } else {
            throw new InvalidChatImageUrlException(this.originalUrl + "<- this url is invalid, Please Check again", InvalidChatImageUrlException.InvalidUrlMode.NotFound);
        }
    }

    public ChatImageUrl(String url) throws InvalidChatImageUrlException {
        this(ChatImageUrl.loadUri(url));
    }

    public String getOriginalUrl() {
        return this.originalUrl;
    }

    public UrlMethod getUrlMethod() {
        return this.urlMethod;
    }

    public String getUrl() {
        if (this.urlMethod == UrlMethod.FILE) {
            return this.fileUrl;
        }
        return this.httpUrl;
    }

    public String toString() {
        return this.originalUrl;
    }

    public static enum UrlMethod {
        FILE,
        HTTP;

    }

    @FunctionalInterface
    public static interface CachePathHelper {
        public void check();
    }

    @FunctionalInterface
    public static interface NetworkHelper {
        public void send(String var1, File var2, boolean var3);
    }
}

