/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.spt.impls;

import io.github.kloping.map.MapUtils;
import io.github.kloping.spt.PartUtils;
import io.github.kloping.spt.annotations.ComponentScan;
import io.github.kloping.spt.annotations.Controller;
import io.github.kloping.spt.annotations.Entity;
import io.github.kloping.spt.interfaces.AutomaticWiringParams;
import io.github.kloping.spt.interfaces.Logger;
import io.github.kloping.spt.interfaces.component.ActionManager;
import io.github.kloping.spt.interfaces.component.ClassManager;
import io.github.kloping.spt.interfaces.component.ContextManager;
import io.github.kloping.spt.interfaces.component.InstanceCrater;
import io.github.kloping.spt.interfaces.component.up0.ClassAttributeManager;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;

public class ClassManagerImpl
implements ClassManager {
    private InstanceCrater instanceCrater;
    private ContextManager contextManager;
    private AutomaticWiringParams automaticWiringParams;
    private ActionManager actionManager;
    private Map<Class<? extends Annotation>, List<ClassAttributeManager>> registeredAnnotations = new ConcurrentHashMap<Class<? extends Annotation>, List<ClassAttributeManager>>();
    private Set<Class<?>> set = new CopyOnWriteArraySet();

    public ClassManagerImpl(InstanceCrater instanceCrater, ContextManager contextManager, AutomaticWiringParams automaticWiringParams, ActionManager actionManager) {
        this.instanceCrater = instanceCrater;
        this.contextManager = contextManager;
        this.automaticWiringParams = automaticWiringParams;
        this.actionManager = actionManager;
    }

    @Override
    public <T extends Annotation> void registeredAnnotation(Class<T> annotation, ClassAttributeManager attributeManager) {
        MapUtils.append(this.registeredAnnotations, annotation, (Object)attributeManager, CopyOnWriteArrayList.class);
    }

    @Override
    public void add(Class<?> cla) {
        Object o;
        Object object;
        if (!this.set.add(cla)) {
            return;
        }
        String id = null;
        if (cla.isAnnotationPresent(ComponentScan.class)) {
            object = this.contextManager.getContextEntity(cla);
        }
        if (cla.isAnnotationPresent(Entity.class) && (o = this.contextManager.getContextEntity(cla)) == null) {
            id = cla.getDeclaredAnnotation(Entity.class).value();
            this.createBeanByIdAndCla(id, cla);
        }
        if (cla.isAnnotationPresent(Controller.class) && (o = this.contextManager.getContextEntity(cla)) == null) {
            id = cla.getDeclaredAnnotation(Controller.class).value();
            object = this.createBeanByIdAndCla(id, cla);
        }
        for (Class clazz : this.registeredAnnotations.keySet()) {
            if (!cla.isAnnotationPresent(clazz)) continue;
            for (ClassAttributeManager classAttributeManager : this.registeredAnnotations.get(clazz)) {
                try {
                    classAttributeManager.manager(cla, this.contextManager);
                }
                catch (Exception e) {
                    Logger logger = this.contextManager.getContextEntity(Logger.class);
                    if (logger != null) {
                        logger.error(PartUtils.getExceptionLine(e));
                        continue;
                    }
                    e.printStackTrace();
                }
            }
        }
    }

    private Object createBeanByIdAndCla(String id, Class cla) {
        Object o = this.instanceCrater.create(cla, this.contextManager);
        if (o != null) {
            this.contextManager.append(o, id);
        }
        return o;
    }
}

