/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.spt.impls;

import io.github.kloping.spt.PartUtils;
import io.github.kloping.spt.Setting;
import io.github.kloping.spt.entity.interfaces.Runner;
import io.github.kloping.spt.entity.interfaces.RunnerOnThrows;
import io.github.kloping.spt.impls.ExecutorNowImpl;
import io.github.kloping.spt.interfaces.Executor;
import io.github.kloping.spt.interfaces.Logger;
import io.github.kloping.spt.interfaces.QueueExecutor;
import io.github.kloping.spt.interfaces.entitys.MatherResult;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class QueueExecutorImpl
extends ExecutorNowImpl
implements QueueExecutor {
    private Class<?> cla = Long.class;
    private int poolSize = 20;
    private long waitTime = 10000L;
    private Runner runner1;
    private Runner runner2;
    private RunnerOnThrows onThrows;
    protected Executor executor;
    protected Setting setting;
    protected Logger logger;
    private ExecutorService threads;
    private ExecutorService runThreads = null;
    private Map<Object, Queue> queueMap = new ConcurrentHashMap<Object, Queue>();
    private Set<Object> runSet = new CopyOnWriteArraySet<Object>();

    public QueueExecutorImpl(Setting setting) {
        this.setting = setting;
        setting.getSTARTED_RUNNABLE().add(() -> {
            this.logger = setting.getContextManager().getContextEntity(Logger.class);
        });
    }

    @Override
    public <T extends Runner> void setBefore(T runner) {
        this.runner1 = runner;
    }

    @Override
    public <T extends Runner> void setAfter(T runner) {
        this.runner2 = runner;
    }

    @Override
    public <T extends RunnerOnThrows> void setException(T r) {
        this.onThrows = r;
    }

    private void init() {
        this.threads = new ThreadPoolExecutor(this.poolSize, this.poolSize, this.waitTime, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(this.poolSize));
        this.runThreads = Executors.newFixedThreadPool(this.poolSize);
    }

    public static QueueExecutor create(Class<?> cla, int poolSize, long waitTime, Executor executor, Setting setting) {
        QueueExecutorImpl queueExecutor = new QueueExecutorImpl(setting);
        queueExecutor.executor = executor;
        queueExecutor.poolSize = poolSize;
        queueExecutor.cla = cla;
        queueExecutor.waitTime = waitTime;
        queueExecutor.init();
        return queueExecutor;
    }

    @Override
    public <T> int queueExecute(T t, Object ... objects) {
        if (t.getClass() != this.cla) {
            this.logger.Log("not is mainKey type for " + t.getClass().getSimpleName(), 2);
            return 0;
        }
        if (this.runSet.add(t)) {
            this.runThreads.execute(() -> {
                Future<?> future = this.threads.submit(() -> {
                    block9: {
                        long startTime = System.currentTimeMillis();
                        Object[] parts = Arrays.copyOfRange(objects, 2, objects.length);
                        if (this.setting.getArgsManager().isLegal(parts)) {
                            try {
                                MatherResult result = (MatherResult)this.setting.getActionManager().mather(objects[1].toString());
                                if (result != null && result.getMethods().length > 0) {
                                    Method[] methods = result.getMethods();
                                    Class<?> cla = methods[0].getDeclaringClass();
                                    if (this.runner1 != null) {
                                        this.runner1.run(methods[0], t, objects);
                                    }
                                    Object o = this.setting.getContextManager().getContextEntity(cla);
                                    Object reo = null;
                                    ArrayList<Object> results = new ArrayList<Object>();
                                    for (Method m : methods) {
                                        Object[] parObjs = this.setting.getAutomaticWiringParams().wiring(m, result, results, parts);
                                        Object to = this.execute(o, m, parObjs);
                                        if (to == null) continue;
                                        results.add(to);
                                        reo = to;
                                    }
                                    if (this.runner2 != null) {
                                        this.runner2.run(methods[0], reo, objects);
                                    }
                                    this.logger.Log("lost time " + (System.currentTimeMillis() - startTime) + " Millisecond", 1);
                                    break block9;
                                }
                                this.logger.Log("No match for " + objects[1].toString(), 2);
                            }
                            catch (Throwable e) {
                                if (this.onThrows != null) {
                                    this.onThrows.onThrows(e, t, objects);
                                    break block9;
                                }
                                this.logger.error(PartUtils.getExceptionLine(e));
                            }
                        } else {
                            this.logger.waring("Can't Access types for " + Arrays.toString(objects));
                        }
                    }
                });
                try {
                    future.get(this.waitTime, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    this.logger.Log("Running Has Error\n" + PartUtils.getExceptionLine(e), -1);
                    future.cancel(true);
                }
                catch (TimeoutException e) {
                    this.logger.Log("Run Time Out\n" + PartUtils.getExceptionLine(e), -1);
                    future.cancel(true);
                }
                catch (Exception e) {
                    this.logger.Log("Other Error\n" + PartUtils.getExceptionLine(e), -1);
                    e.printStackTrace();
                    future.cancel(true);
                }
                this.runSet.remove(t);
                if (this.queueMap.containsKey(t)) {
                    this.queueExecute(t, this.end(t));
                }
            });
            return this.queueMap.size();
        }
        this.append(t, objects);
        this.logger.Log("append queue list and next run", 0);
        return 0;
    }

    private void append(Object t, Object ... objects) {
        if (this.queueMap.containsKey(t)) {
            this.queueMap.get(t).offer(objects);
        } else {
            ConcurrentLinkedDeque<Object[]> queue = new ConcurrentLinkedDeque<Object[]>();
            queue.offer(objects);
            this.queueMap.put(t, queue);
        }
    }

    private Object[] end(Object t) {
        Object[] objects = null;
        if (this.queueMap.containsKey(t)) {
            objects = (Object[])this.queueMap.get(t).poll();
        }
        if (this.queueMap.get(t).isEmpty()) {
            this.queueMap.remove(t);
        }
        return objects;
    }
}

