/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot.entities.qqpd.message;

import io.github.kloping.qqbot.api.DirectSender;
import io.github.kloping.qqbot.entities.qqpd.Channel;
import io.github.kloping.qqbot.entities.qqpd.Member;
import io.github.kloping.qqbot.entities.qqpd.User;
import io.github.kloping.qqbot.entities.qqpd.message.MessageAttachment;
import io.github.kloping.qqbot.entities.qqpd.message.MessageReference;
import io.github.kloping.qqbot.entities.qqpd.message.RawMessage;
import io.github.kloping.qqbot.entities.qqpd.message.RawPreMessage;
import io.github.kloping.qqbot.http.data.ActionResult;
import io.github.kloping.qqbot.impl.MessagePacket;
import io.github.kloping.qqbot.utils.BaseUtils;
import java.util.Arrays;

public class DirectMessage
extends RawMessage
implements DirectSender {
    private String id;
    private String channelId;
    private String guildId;
    private String content;
    private String timestamp;
    private String editedTimestamp;
    private Boolean mentionEveryone;
    private User author;
    private MessageAttachment[] attachments;
    private Object embed;
    private User[] mentions;
    private Member member;
    private Object ark;
    private Integer seq;
    private String seqInChannel;
    private MessageReference messageReference;
    private String srcGuildId;

    public static DirectMessage messageAsDirectMessage(RawMessage message) {
        return new DirectMessage().setId(message.getId()).setChannelId(message.getChannelId()).setGuildId(message.getGuildId()).setContent(message.getContent()).setTimestamp(message.getTimestamp()).setEditedTimestamp(message.getEditedTimestamp()).setMentionEveryone(message.getMentionEveryone()).setAuthor(message.getAuthor()).setAttachments(message.getAttachments()).setEmbed(message.getEmbed()).setMentions(message.getMentions()).setMember(message.getMember()).setArk(message.getArk()).setSeq(message.getSeq()).setSeqInChannel(message.getSeqInChannel()).setMessageReference(message.getMessageReference()).setSrcGuildId(message.getSrcGuildId());
    }

    @Override
    public ActionResult send(String text) {
        return this.sendDirect(text);
    }

    @Override
    public ActionResult send(String text, RawMessage message) {
        return this.sendDirect(text, message);
    }

    @Override
    public ActionResult send(MessagePacket packet) {
        return this.sendDirect(packet);
    }

    @Override
    public ActionResult send(RawPreMessage msg) {
        return this.sendDirect(msg);
    }

    @Override
    public ActionResult sendDirect(String text) {
        return this.sendDirect(new MessagePacket().setContent(text));
    }

    @Override
    public ActionResult sendDirect(String text, RawMessage message) {
        return this.sendDirect(new MessagePacket().setContent(text).setReplyId(message.getId()));
    }

    @Override
    public ActionResult sendDirect(MessagePacket packet) {
        RawPreMessage msg = new RawPreMessage();
        msg.setMsgId(this.id);
        BaseUtils.packet2pre(packet, msg);
        return this.getBot().dmsBase.send(this.guildId, msg, Channel.SEND_MESSAGE_HEADERS);
    }

    @Override
    public ActionResult sendDirect(RawPreMessage msg) {
        return this.getBot().dmsBase.send(this.guildId, msg, Channel.SEND_MESSAGE_HEADERS);
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public Object delete() {
        return this.getBot().dmsBase.delete(this.guildId, this.id, false);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    public String getGuildId() {
        return this.guildId;
    }

    @Override
    public String getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getEditedTimestamp() {
        return this.editedTimestamp;
    }

    @Override
    public Boolean getMentionEveryone() {
        return this.mentionEveryone;
    }

    @Override
    public User getAuthor() {
        return this.author;
    }

    @Override
    public MessageAttachment[] getAttachments() {
        return this.attachments;
    }

    @Override
    public Object getEmbed() {
        return this.embed;
    }

    @Override
    public User[] getMentions() {
        return this.mentions;
    }

    @Override
    public Member getMember() {
        return this.member;
    }

    @Override
    public Object getArk() {
        return this.ark;
    }

    @Override
    public Integer getSeq() {
        return this.seq;
    }

    @Override
    public String getSeqInChannel() {
        return this.seqInChannel;
    }

    @Override
    public MessageReference getMessageReference() {
        return this.messageReference;
    }

    @Override
    public String getSrcGuildId() {
        return this.srcGuildId;
    }

    @Override
    public DirectMessage setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    public DirectMessage setChannelId(String channelId) {
        this.channelId = channelId;
        return this;
    }

    @Override
    public DirectMessage setGuildId(String guildId) {
        this.guildId = guildId;
        return this;
    }

    @Override
    public DirectMessage setContent(String content) {
        this.content = content;
        return this;
    }

    @Override
    public DirectMessage setTimestamp(String timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Override
    public DirectMessage setEditedTimestamp(String editedTimestamp) {
        this.editedTimestamp = editedTimestamp;
        return this;
    }

    @Override
    public DirectMessage setMentionEveryone(Boolean mentionEveryone) {
        this.mentionEveryone = mentionEveryone;
        return this;
    }

    @Override
    public DirectMessage setAuthor(User author) {
        this.author = author;
        return this;
    }

    @Override
    public DirectMessage setAttachments(MessageAttachment[] attachments) {
        this.attachments = attachments;
        return this;
    }

    @Override
    public DirectMessage setEmbed(Object embed) {
        this.embed = embed;
        return this;
    }

    @Override
    public DirectMessage setMentions(User[] mentions) {
        this.mentions = mentions;
        return this;
    }

    @Override
    public DirectMessage setMember(Member member) {
        this.member = member;
        return this;
    }

    @Override
    public DirectMessage setArk(Object ark) {
        this.ark = ark;
        return this;
    }

    @Override
    public DirectMessage setSeq(Integer seq) {
        this.seq = seq;
        return this;
    }

    @Override
    public DirectMessage setSeqInChannel(String seqInChannel) {
        this.seqInChannel = seqInChannel;
        return this;
    }

    @Override
    public DirectMessage setMessageReference(MessageReference messageReference) {
        this.messageReference = messageReference;
        return this;
    }

    @Override
    public DirectMessage setSrcGuildId(String srcGuildId) {
        this.srcGuildId = srcGuildId;
        return this;
    }

    @Override
    public String toString() {
        return "DirectMessage(id=" + this.getId() + ", channelId=" + this.getChannelId() + ", guildId=" + this.getGuildId() + ", content=" + this.getContent() + ", timestamp=" + this.getTimestamp() + ", editedTimestamp=" + this.getEditedTimestamp() + ", mentionEveryone=" + this.getMentionEveryone() + ", author=" + this.getAuthor() + ", attachments=" + Arrays.deepToString(this.getAttachments()) + ", embed=" + this.getEmbed() + ", mentions=" + Arrays.deepToString(this.getMentions()) + ", member=" + this.getMember() + ", ark=" + this.getArk() + ", seq=" + this.getSeq() + ", seqInChannel=" + this.getSeqInChannel() + ", messageReference=" + this.getMessageReference() + ", srcGuildId=" + this.getSrcGuildId() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DirectMessage)) {
            return false;
        }
        DirectMessage other = (DirectMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$mentionEveryone = this.getMentionEveryone();
        Boolean other$mentionEveryone = other.getMentionEveryone();
        if (this$mentionEveryone == null ? other$mentionEveryone != null : !((Object)this$mentionEveryone).equals(other$mentionEveryone)) {
            return false;
        }
        Integer this$seq = this.getSeq();
        Integer other$seq = other.getSeq();
        if (this$seq == null ? other$seq != null : !((Object)this$seq).equals(other$seq)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$channelId = this.getChannelId();
        String other$channelId = other.getChannelId();
        if (this$channelId == null ? other$channelId != null : !this$channelId.equals(other$channelId)) {
            return false;
        }
        String this$guildId = this.getGuildId();
        String other$guildId = other.getGuildId();
        if (this$guildId == null ? other$guildId != null : !this$guildId.equals(other$guildId)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$timestamp = this.getTimestamp();
        String other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp)) {
            return false;
        }
        String this$editedTimestamp = this.getEditedTimestamp();
        String other$editedTimestamp = other.getEditedTimestamp();
        if (this$editedTimestamp == null ? other$editedTimestamp != null : !this$editedTimestamp.equals(other$editedTimestamp)) {
            return false;
        }
        User this$author = this.getAuthor();
        User other$author = other.getAuthor();
        if (this$author == null ? other$author != null : !((Object)this$author).equals(other$author)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getAttachments(), other.getAttachments())) {
            return false;
        }
        Object this$embed = this.getEmbed();
        Object other$embed = other.getEmbed();
        if (this$embed == null ? other$embed != null : !this$embed.equals(other$embed)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getMentions(), other.getMentions())) {
            return false;
        }
        Member this$member = this.getMember();
        Member other$member = other.getMember();
        if (this$member == null ? other$member != null : !((Object)this$member).equals(other$member)) {
            return false;
        }
        Object this$ark = this.getArk();
        Object other$ark = other.getArk();
        if (this$ark == null ? other$ark != null : !this$ark.equals(other$ark)) {
            return false;
        }
        String this$seqInChannel = this.getSeqInChannel();
        String other$seqInChannel = other.getSeqInChannel();
        if (this$seqInChannel == null ? other$seqInChannel != null : !this$seqInChannel.equals(other$seqInChannel)) {
            return false;
        }
        MessageReference this$messageReference = this.getMessageReference();
        MessageReference other$messageReference = other.getMessageReference();
        if (this$messageReference == null ? other$messageReference != null : !((Object)this$messageReference).equals(other$messageReference)) {
            return false;
        }
        String this$srcGuildId = this.getSrcGuildId();
        String other$srcGuildId = other.getSrcGuildId();
        return !(this$srcGuildId == null ? other$srcGuildId != null : !this$srcGuildId.equals(other$srcGuildId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DirectMessage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $mentionEveryone = this.getMentionEveryone();
        result = result * 59 + ($mentionEveryone == null ? 43 : ((Object)$mentionEveryone).hashCode());
        Integer $seq = this.getSeq();
        result = result * 59 + ($seq == null ? 43 : ((Object)$seq).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $channelId = this.getChannelId();
        result = result * 59 + ($channelId == null ? 43 : $channelId.hashCode());
        String $guildId = this.getGuildId();
        result = result * 59 + ($guildId == null ? 43 : $guildId.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
        String $editedTimestamp = this.getEditedTimestamp();
        result = result * 59 + ($editedTimestamp == null ? 43 : $editedTimestamp.hashCode());
        User $author = this.getAuthor();
        result = result * 59 + ($author == null ? 43 : ((Object)$author).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getAttachments());
        Object $embed = this.getEmbed();
        result = result * 59 + ($embed == null ? 43 : $embed.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getMentions());
        Member $member = this.getMember();
        result = result * 59 + ($member == null ? 43 : ((Object)$member).hashCode());
        Object $ark = this.getArk();
        result = result * 59 + ($ark == null ? 43 : $ark.hashCode());
        String $seqInChannel = this.getSeqInChannel();
        result = result * 59 + ($seqInChannel == null ? 43 : $seqInChannel.hashCode());
        MessageReference $messageReference = this.getMessageReference();
        result = result * 59 + ($messageReference == null ? 43 : ((Object)$messageReference).hashCode());
        String $srcGuildId = this.getSrcGuildId();
        result = result * 59 + ($srcGuildId == null ? 43 : $srcGuildId.hashCode());
        return result;
    }
}

