/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot.network;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.github.kloping.MySpringTool.annotations.AutoStand;
import io.github.kloping.MySpringTool.annotations.AutoStandAfter;
import io.github.kloping.MySpringTool.annotations.Entity;
import io.github.kloping.MySpringTool.interfaces.Logger;
import io.github.kloping.common.Public;
import io.github.kloping.object.ObjectUtils;
import io.github.kloping.qqbot.Starter;
import io.github.kloping.qqbot.api.event.Event;
import io.github.kloping.qqbot.entities.Bot;
import io.github.kloping.qqbot.entities.Pack;
import io.github.kloping.qqbot.entities.qqpd.message.RawMessage;
import io.github.kloping.qqbot.impl.ListenerHost;
import io.github.kloping.qqbot.interfaces.OnPackReceive;
import io.github.kloping.qqbot.network.WssWorker;
import io.github.kloping.qqbot.utils.InvokeUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

@Entity
public class Events
implements OnPackReceive {
    @AutoStand
    Starter.Config config;
    @AutoStand
    Logger logger;
    @AutoStand
    Bot bot;
    private final Map<Method, ListenerHost> m2l = new HashMap<Method, ListenerHost>();
    public Map<String, EventRegister> id2reg = new HashMap<String, EventRegister>();

    @AutoStandAfter
    public void r1(WssWorker wssWorker) {
        wssWorker.getOnPackReceives().add(this);
    }

    @Override
    public boolean onReceive(Pack pack) {
        String t = pack.getT();
        if (t == null) {
            return false;
        }
        JSONObject jo = JSON.parseObject((String)JSON.toJSONString((Object)pack.getD()));
        Public.EXECUTOR_SERVICE.submit(() -> {
            try {
                this.onEvent(t, jo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        return false;
    }

    private void onEvent(String t, JSONObject obj) throws Exception {
        Object c0 = null;
        RawMessage msg = (RawMessage)obj.toJavaObject(RawMessage.class);
        if (msg == null) {
            this.logger.waring(String.format("Unknown Pack(%s)", obj.toString()));
            return;
        }
        EventRegister register = this.id2reg.get(t);
        if (register == null) {
            this.logger.waring(String.format("%s yet not registered", t));
            return;
        }
        msg.setBot(this.bot);
        Event event = register.handle(t, obj, msg);
        if (event == null) {
            return;
        }
        for (Method method : this.getM2L().keySet()) {
            ListenerHost l = this.getM2L().get(method);
            if (!ObjectUtils.isSuperOrInterface(event.getClass(), method.getParameterTypes()[0])) continue;
            Public.EXECUTOR_SERVICE.submit(() -> {
                try {
                    method.invoke((Object)l, event);
                }
                catch (IllegalAccessException e) {
                    this.logger.error("EventReceiver The method parameter is set incorrectly");
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.getTargetException().printStackTrace();
                    l.handleException(e.getTargetException());
                }
            });
        }
        this.logger.info(String.format("Bot(%s) %s post(%s)", this.bot.getInfo().getUsername(), event.getClass().getSimpleName(), event));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Method, ListenerHost> getM2L() {
        if (this.m2l.isEmpty()) {
            Map<Method, ListenerHost> map = this.m2l;
            synchronized (map) {
                for (ListenerHost listenerHost : this.config.getListenerHosts()) {
                    for (Method method : InvokeUtils.getAllMethod(listenerHost)) {
                        this.m2l.put(method, listenerHost);
                    }
                }
            }
        }
        return this.m2l;
    }

    public EventRegister register(String id, EventRegister register) {
        return this.id2reg.put(id, register);
    }

    public static interface EventRegister {
        public Event handle(String var1, JSONObject var2, RawMessage var3);
    }
}

