/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot.utils;

import io.github.kloping.arr.ArrDeSerializer;
import io.github.kloping.number.NumberUtils;
import io.github.kloping.qqbot.api.SendAble;
import io.github.kloping.qqbot.entities.ex.At;
import io.github.kloping.qqbot.entities.ex.AtAll;
import io.github.kloping.qqbot.entities.ex.Image;
import io.github.kloping.qqbot.entities.ex.PlainText;
import io.github.kloping.qqbot.entities.ex.msg.MessageChain;
import io.github.kloping.qqbot.entities.qqpd.data.Emoji;
import java.util.regex.Pattern;

public class PdCode {
    public static final ArrDeSerializer<SendAble> DE_SERIALIZER = new ArrDeSerializer();
    public static final Pattern AT_PATTERN = Pattern.compile("<at:.*?>");
    public static final Pattern AT_ALL_PATTERN = Pattern.compile("<atAll>");
    public static final Pattern EMOJI_PATTERN = Pattern.compile("<emoji:[0-9]+>");
    public static final Pattern IMAGE_PATTERN = Pattern.compile("<image:.*?>");

    public static String serializeToPdCode(MessageChain chain) {
        StringBuilder sb = new StringBuilder();
        chain.forEach(e -> sb.append(PdCode.serializeToPdCode(e)));
        return sb.toString();
    }

    public static String serializeToPdCode(SendAble[] datas) {
        StringBuilder sb = new StringBuilder();
        for (SendAble data : datas) {
            sb.append(PdCode.serializeToPdCode(data));
        }
        return sb.toString();
    }

    public static String serializeToPdCode(SendAble e) {
        if (e instanceof Emoji) {
            Emoji emoji = (Emoji)e;
            return String.format("<emoji:%s>", emoji.getId());
        }
        if (e instanceof At) {
            At at = (At)e;
            return String.format("<at:%s>", at.getTargetId());
        }
        if (e instanceof AtAll) {
            AtAll atAll = (AtAll)e;
            return "<atAll>";
        }
        if (e instanceof Image) {
            Image image = (Image)e;
            return String.format("<image:%s>", image.getUrl().startsWith("http") ? image.getUrl() : "https://" + image.getUrl());
        }
        if (e instanceof PlainText) {
            PlainText plainText = (PlainText)e;
            return plainText.toString();
        }
        return e.toString();
    }

    public static MessageChain deserializePdCode(String pdCode) {
        MessageChain chain = new MessageChain();
        for (SendAble sendAble : DE_SERIALIZER.deserializer(pdCode)) {
            chain.append(sendAble);
        }
        return chain;
    }

    static {
        DE_SERIALIZER.add(AT_PATTERN, (ArrDeSerializer.Rule0)new ArrDeSerializer.Rule0<At>(){

            public At deserializer(String s) {
                return new At("member", NumberUtils.findNumberFromString((String)s));
            }
        });
        DE_SERIALIZER.add(AT_ALL_PATTERN, (ArrDeSerializer.Rule0)new ArrDeSerializer.Rule0<AtAll>(){

            public AtAll deserializer(String s) {
                return new AtAll();
            }
        });
        DE_SERIALIZER.add(EMOJI_PATTERN, (ArrDeSerializer.Rule0)new ArrDeSerializer.Rule0<Emoji>(){

            public Emoji deserializer(String s) {
                return Emoji.valueOf(Integer.valueOf(NumberUtils.findNumberFromString((String)s)));
            }
        });
        DE_SERIALIZER.add(IMAGE_PATTERN, (ArrDeSerializer.Rule0)new ArrDeSerializer.Rule0<Image>(){

            public Image deserializer(String s) {
                return new Image(s.substring(7, s.length() - 1));
            }
        });
        DE_SERIALIZER.add(ArrDeSerializer.EMPTY_PATTERN, (ArrDeSerializer.Rule0)new ArrDeSerializer.Rule0<PlainText>(){

            public PlainText deserializer(String s) {
                return new PlainText(s);
            }
        });
    }
}

