/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.github.kloping.common.Public;
import io.github.kloping.qqbot.Resource;
import io.github.kloping.qqbot.api.BotContent;
import io.github.kloping.qqbot.api.exc.RequestException;
import io.github.kloping.qqbot.entities.Bot;
import io.github.kloping.qqbot.entities.exc.QBotError;
import io.github.kloping.qqbot.entities.qqpd.message.RawMessage;
import io.github.kloping.qqbot.http.data.ActionResult;
import io.github.kloping.spt.annotations.AutoStand;
import io.github.kloping.spt.annotations.AutoStandAfter;
import io.github.kloping.spt.annotations.Entity;
import io.github.kloping.spt.impls.HttpStatusReceiver;
import io.github.kloping.spt.impls.LoggerImpl;
import io.github.kloping.spt.interfaces.Logger;
import io.github.kloping.spt.interfaces.component.HttpClientManager;
import java.awt.Color;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.fusesource.jansi.Ansi;
import org.jsoup.Connection;
import org.jsoup.nodes.Document;

@Entity
public class HttpClientConfig
implements HttpStatusReceiver {
    @AutoStand
    Logger logger;
    @AutoStand
    Bot bot;
    private final Color methodColor = new Color(111, 167, 241, 219);
    private final Color interfaceColor = new Color(114, 225, 158, 219);
    private final Color dataColor = new Color(232, 135, 180, 179);
    private final Color urlColor = new Color(229, 178, 127, 219);

    @AutoStandAfter
    public void after(HttpClientManager manager) {
        manager.addHttpStatusReceiver((HttpStatusReceiver)this);
    }

    public void receive(HttpClientManager manager, String url, Integer code, Class<?> interface0, Method method, Connection.Method reqMethod, Class<?> cla, Object o, Document metadata) {
        if (o == null || code == null || metadata == null) {
            return;
        }
        this.logger.log(String.format("Use the (%s) method through the (%s) interface to request the data obtained by the response code of the (%s) URL is (%s), and (%s) may be converted to (%s) type Will be processed and filtered", Ansi.ansi().fgRgb(this.methodColor.getRGB()).a(reqMethod.name()).reset().toString(), Ansi.ansi().fgRgb(this.interfaceColor.getRGB()).a(interface0.getSimpleName()).reset().toString(), Ansi.ansi().fgRgb(this.urlColor.getRGB()).a(url).reset().toString(), code >= 400 || code < 200 ? Ansi.ansi().fgRgb(LoggerImpl.ERROR_COLOR.getRGB()).a((Object)code).reset().toString() : Ansi.ansi().fgRgb(LoggerImpl.INFO_COLOR.getRGB()).a((Object)code).reset().toString(), code >= 400 || code < 200 ? Ansi.ansi().fgRgb(LoggerImpl.ERROR_COLOR.getRGB()).a(metadata.body().wholeText()).reset().toString() : Ansi.ansi().fgRgb(this.dataColor.getRGB()).a(metadata.body().wholeText()).reset().toString(), Ansi.ansi().fgRgb(LoggerImpl.NORMAL_LOW_COLOR.getRGB()).a(o).reset().toString()));
        this.fillAll(cla, o);
        Public.EXECUTOR_SERVICE.submit(() -> {
            ActionResult result;
            if (o instanceof ActionResult && (result = (ActionResult)o).getSent().booleanValue()) {
                RawMessage rawMessage = result.getRawMessage();
                if (url.contains("dms")) {
                    this.logger.info(String.format("Bot(%s): %s <= %s", this.bot.getInfo().getUsername(), rawMessage.getChannelId() + "(\u79c1\u4fe1)", rawMessage.getContent().trim()));
                } else {
                    this.logger.info(String.format("Bot(%s): %s <= %s", this.bot.getInfo().getUsername(), this.bot.getGuild(rawMessage.getGuildId()).getChannel(rawMessage.getChannelId()).getName(), rawMessage.getContent().trim()));
                }
            }
        });
        if (code >= 400 || code < 200) {
            RequestException requestException = null;
            String bodyJson = metadata.body().wholeText();
            JSONObject exjo = JSON.parseObject((String)bodyJson);
            QBotError error = (QBotError)exjo.toJavaObject(QBotError.class);
            int eccode = exjo.getInteger("code");
            if (Resource.CODE2EXCEPTION.containsKey(eccode)) {
                try {
                    Class<? extends RequestException> exceptionClass = Resource.CODE2EXCEPTION.get(eccode);
                    Constructor<? extends RequestException> constructor = exceptionClass.getConstructor(Integer.TYPE, String.class, String.class, String.class);
                    requestException = constructor.newInstance(eccode, bodyJson, url, method.getName());
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                }
            } else {
                requestException = new RequestException(eccode, bodyJson, url, method.getName());
            }
            if (requestException != null) {
                requestException.setData(error);
            }
            throw requestException;
        }
    }

    public void fillAll(Class<?> cla, Object o) {
        if (o instanceof BotContent) {
            BotContent content = (BotContent)o;
            content.setBot(this.bot);
        }
        if (cla.isArray()) {
            Object[] obs;
            for (Object ob : obs = (Object[])o) {
                if (!(ob instanceof BotContent)) continue;
                BotContent content = (BotContent)ob;
                content.setBot(this.bot);
            }
        }
    }
}

