package com.liecoder.framework.ktx

import android.util.Log

/**
 * Prints an error log with the provided message.
 * Uses the simple name of the calling class as the log tag.
 *
 * @param message The message to be logged. If null or empty, a default message will be used.
 */
fun Any.e(message: String?) {
    val tag = this@e::class.java.simpleName
    val logMessage = if (message.isNullOrEmpty()) "message is null or empty!" else message
    Log.e(tag, logMessage)
}

/**
 * Prints a debug log with the provided message.
 * Uses the simple name of the calling class as the log tag.
 *
 * @param message The message to be logged. If null or empty, a default message will be used.
 */
fun Any.d(message: String?) {
    val tag = this@d::class.java.simpleName
    val logMessage = if (message.isNullOrEmpty()) "message is null or empty!" else message
    Log.d(tag, logMessage)
}

/**
 * Prints an info log with the provided message.
 * Uses the simple name of the calling class as the log tag.
 *
 * @param message The message to be logged. If null or empty, a default message will be used.
 */
fun Any.i(message: String?) {
    val tag = this@i::class.java.simpleName
    val logMessage = if (message.isNullOrEmpty()) "message is null or empty!" else message
    Log.i(tag, logMessage)
}

/**
 * Prints a warning log with the provided message.
 * Uses the simple name of the calling class as the log tag.
 *
 * @param message The message to be logged. If null or empty, a default message will be used.
 */
fun Any.w(message: String?) {
    val tag = this@w::class.java.simpleName
    val logMessage = if (message.isNullOrEmpty()) "message is null or empty!" else message
    Log.w(tag, logMessage)
}

/**
 * Prints a verbose log with the provided message.
 * Uses the simple name of the calling class as the log tag.
 *
 * @param message The message to be logged. If null or empty, a default message will be used.
 */
fun Any.v(message: String?) {
    val tag = this@v::class.java.simpleName
    val logMessage = if (message.isNullOrEmpty()) "message is null or empty!" else message
    Log.v(tag, logMessage)
}
