package com.liecoder.framework.ktx


/**
 * 将当前对象转换为指定类型
 */
inline fun <reified T> Any.saveAs(): T {
    return this as T
}

/**
 * 将当前对象转换为指定类型，不进行类型检查
 */
@Suppress("UNCHECKED_CAST")
fun <T> Any.saveAsUnchecked(): T {
    return this as T
}

/**
 * 判断当前对象是否为指定类型
 */
inline fun <reified T> Any.isEqualType(): Boolean {
    return this is T
}