package com.liecoder.framework.manager

import android.app.Application
import android.content.Context
import android.os.Build
import android.util.DisplayMetrics
import android.view.WindowManager
import kotlin.math.max
import kotlin.math.min

object DeviceInfoManager {

    private lateinit var mContext: Application

    private var mScreenWidthPx = 0
    private var mScreenHeightPx = 0
    private var mScreenWidthDp = 0
    private var mScreenHeightDp = 0
    private var mDensityDpi = 0
    private var mDensity = 0f
    private var mStatusBarHeight = 0
    private var mProductType: String? = null
    private var mIsBiggerScreen = false
    private var mImei: String = ""
    private var mImsi: String = ""
    private var mAndroidId: String = ""
    private var mMac: String = ""
    private var mWifiMacAddress: String = ""
    private var mWifiSSID: String = ""
    private var mPhoneModel: String = ""
    private var mPhoneBrand: String = ""
    private var mPhoneManufacturer: String = ""
    private var mPhoneDevice: String = ""
    private var mAppVersionName: String = ""
    private var mAppVersionCode: Int = 0

    fun init(context: Application) {
        mContext = context
        mPhoneModel = Build.MODEL
        mPhoneBrand = Build.BRAND
        mPhoneManufacturer = Build.MANUFACTURER
        mPhoneDevice = Build.DEVICE
        initImei()
        initMac()
        initAndroidId()
        initScreenInfo()
        initAppVersionName()
        initAppVersionCode()
    }

    private fun initScreenInfo() {
        val windowManager = mContext.getSystemService(Context.WINDOW_SERVICE) as WindowManager
        val metrics = DisplayMetrics()
        windowManager.defaultDisplay.getMetrics(metrics)
        mScreenHeightPx = max(metrics.heightPixels, metrics.widthPixels)
        mScreenWidthPx = min(metrics.heightPixels, metrics.widthPixels)
        mIsBiggerScreen = mScreenHeightPx * 1.0 / mScreenWidthPx > 16.0 / 9
        mDensityDpi = metrics.densityDpi
        mDensity = metrics.density
        mScreenHeightDp = (mScreenHeightPx / mDensity).toInt()
        mScreenWidthDp = (mScreenWidthPx / mDensity).toInt()
        val resourceId = mContext.resources.getIdentifier("status_bar_height", "dimen", "android")
        mStatusBarHeight = mContext.resources.getDimensionPixelSize(resourceId)
        mProductType = genProductType()
    }

    private fun initImei() {

    }

    private fun initMac() {

    }

    private fun initAndroidId() {

    }

    private fun initAppVersionName(){
        try {
            val pm = mContext.packageManager
            val packageName = mContext.packageName ?: "com.liecoder.framework"
            pm.getPackageInfo(packageName, 0).versionName
            val pi = pm.getPackageInfo(packageName, 0)
            mAppVersionName = pi.versionName
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    private fun initAppVersionCode(){
        try {
            val pm = mContext.packageManager
            val packageName = mContext.packageName?: "com.liecoder.framework"
            pm.getPackageInfo(packageName, 0).versionCode
            val pi = pm.getPackageInfo(packageName, 0)
            mAppVersionCode = pi.versionCode
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    private fun genProductType(): String {
        return mPhoneModel.replace("[:{} \\[\\]\"']*".toRegex(), "")
    }

    fun getScreenWidthPx(): Int = mScreenWidthPx
    fun getScreenHeightPx(): Int = mScreenHeightPx
    fun getScreenWidthDp(): Int = mScreenWidthDp
    fun getScreenHeightDp(): Int = mScreenHeightDp
    fun getDensityDpi(): Int = mDensityDpi
    fun getDensity(): Float = mDensity
    fun getStatusBarHeight(): Int = mStatusBarHeight
    fun getProductType(): String? = mProductType
    fun isBiggerScreen(): Boolean = mIsBiggerScreen
    fun getImei(): String = mImei
    fun getImsi(): String = mImsi
    fun getAndroidId(): String = mAndroidId
    fun getMac(): String = mMac
    fun getWifiMacAddress(): String = mWifiMacAddress
    fun getWifiSSID(): String = mWifiSSID
    fun getPhoneModel(): String = mPhoneModel
    fun getPhoneBrand(): String = mPhoneBrand
    fun getPhoneManufacturer(): String = mPhoneManufacturer
    fun getPhoneDevice(): String = mPhoneDevice
    fun getAppVersionName(): String = mAppVersionName
    fun getAppVersionCode(): Int = mAppVersionCode

}