package com.liecoder.framework.titlebar

/**
 * 标题栏点击事件监听接口。
 *
 * 此接口定义了标题栏（TitleBar）上的点击事件处理方法，包括左侧按钮点击、右侧按钮点击和中间标题点击的事件。
 */
interface ITitleBarClickListener {

    /**
     * 处理标题栏左侧点击事件。
     *
     * @param titleBar 被点击的标题栏实例。
     */
    fun onLeftClick(titleBar: TitleBar) {}

    /**
     * 处理标题栏右侧点击事件。
     *
     * @param titleBar 被点击的标题栏实例。
     */
    fun onRightClick(titleBar: TitleBar) {}

    /**
     * 处理标题栏标题的点击事件。
     *
     * @param titleBar 被点击的标题栏实例。
     */
    fun onTitleClick(titleBar: TitleBar) {}

}