/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.binary.tag;

import io.github.lxgaming.binary.tag.CollectionTag;
import java.util.Arrays;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ByteArrayTag
implements CollectionTag {
    private byte[] value;

    public ByteArrayTag() {
        this(new byte[0]);
    }

    public ByteArrayTag(byte @NonNull [] value) {
        this.value = value;
    }

    public byte @NonNull [] getValue() {
        return this.value;
    }

    public void setValue(byte @NonNull [] value) {
        this.value = value;
    }

    public byte get(@NonNegative int index) {
        return this.value[index];
    }

    public void set(@NonNegative int index, byte value) {
        this.value[index] = value;
    }

    @Override
    public int size() {
        return this.value.length;
    }

    @Override
    public @NonNull ByteArrayTag copy() {
        byte[] value = new byte[this.value.length];
        System.arraycopy(this.value, 0, value, 0, value.length);
        return new ByteArrayTag(value);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof ByteArrayTag && Arrays.equals(this.value, ((ByteArrayTag)obj).value);
    }
}

