/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.binary.tag;

import io.github.lxgaming.binary.tag.CollectionTag;
import java.util.Arrays;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class IntArrayTag
implements CollectionTag {
    private int[] value;

    public IntArrayTag() {
        this(new int[0]);
    }

    public IntArrayTag(int @NonNull [] value) {
        this.value = value;
    }

    public int @NonNull [] getValue() {
        return this.value;
    }

    public void setValue(int @NonNull [] value) {
        this.value = value;
    }

    public int get(@NonNegative int index) {
        return this.value[index];
    }

    public void set(@NonNegative int index, int value) {
        this.value[index] = value;
    }

    @Override
    public int size() {
        return this.value.length;
    }

    @Override
    public @NonNull IntArrayTag copy() {
        int[] value = new int[this.value.length];
        System.arraycopy(this.value, 0, value, 0, value.length);
        return new IntArrayTag(value);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof IntArrayTag && Arrays.equals(this.value, ((IntArrayTag)obj).value);
    }
}

