/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.binary.tag;

import io.github.lxgaming.binary.tag.CollectionTag;
import java.util.Arrays;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class FloatArrayTag
implements CollectionTag {
    private float[] value;

    public FloatArrayTag() {
        this(new float[0]);
    }

    public FloatArrayTag(float @NonNull [] value) {
        this.value = value;
    }

    public float @NonNull [] getValue() {
        return this.value;
    }

    public void setValue(float @NonNull [] value) {
        this.value = value;
    }

    public float get(@NonNegative int index) {
        return this.value[index];
    }

    public void set(@NonNegative int index, float value) {
        this.value[index] = value;
    }

    @Override
    public int size() {
        return this.value.length;
    }

    @Override
    public @NonNull FloatArrayTag copy() {
        float[] value = new float[this.value.length];
        System.arraycopy(this.value, 0, value, 0, value.length);
        return new FloatArrayTag(value);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof FloatArrayTag && Arrays.equals(this.value, ((FloatArrayTag)obj).value);
    }
}

