/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.binary.tag;

import io.github.lxgaming.binary.tag.CollectionTag;
import java.util.Arrays;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class LongArrayTag
implements CollectionTag {
    private long[] value;

    public LongArrayTag() {
        this(new long[0]);
    }

    public LongArrayTag(long @NonNull [] value) {
        this.value = value;
    }

    public long @NonNull [] getValue() {
        return this.value;
    }

    public void setValue(long @NonNull [] value) {
        this.value = value;
    }

    public long get(@NonNegative int index) {
        return this.value[index];
    }

    public void set(@NonNegative int index, long value) {
        this.value[index] = value;
    }

    @Override
    public int size() {
        return this.value.length;
    }

    @Override
    public @NonNull LongArrayTag copy() {
        long[] value = new long[this.value.length];
        System.arraycopy(this.value, 0, value, 0, value.length);
        return new LongArrayTag(value);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof LongArrayTag && Arrays.equals(this.value, ((LongArrayTag)obj).value);
    }
}

