/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.binary.tag;

import io.github.lxgaming.binary.tag.CollectionTag;
import java.util.Arrays;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ShortArrayTag
implements CollectionTag {
    private short[] value;

    public ShortArrayTag() {
        this(new short[0]);
    }

    public ShortArrayTag(short @NonNull [] value) {
        this.value = value;
    }

    public short @NonNull [] getValue() {
        return this.value;
    }

    public void setValue(short @NonNull [] value) {
        this.value = value;
    }

    public short get(@NonNegative int index) {
        return this.value[index];
    }

    public void set(@NonNegative int index, short value) {
        this.value[index] = value;
    }

    @Override
    public int size() {
        return this.value.length;
    }

    @Override
    public @NonNull ShortArrayTag copy() {
        short[] value = new short[this.value.length];
        System.arraycopy(this.value, 0, value, 0, value.length);
        return new ShortArrayTag(value);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof ShortArrayTag && Arrays.equals(this.value, ((ShortArrayTag)obj).value);
    }
}

