/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.binary.tag;

import io.github.lxgaming.binary.tag.BooleanTag;
import io.github.lxgaming.binary.tag.ByteArrayTag;
import io.github.lxgaming.binary.tag.ByteTag;
import io.github.lxgaming.binary.tag.CollectionTag;
import io.github.lxgaming.binary.tag.DoubleArrayTag;
import io.github.lxgaming.binary.tag.DoubleTag;
import io.github.lxgaming.binary.tag.FloatArrayTag;
import io.github.lxgaming.binary.tag.FloatTag;
import io.github.lxgaming.binary.tag.IntArrayTag;
import io.github.lxgaming.binary.tag.IntTag;
import io.github.lxgaming.binary.tag.ListTag;
import io.github.lxgaming.binary.tag.LongArrayTag;
import io.github.lxgaming.binary.tag.LongTag;
import io.github.lxgaming.binary.tag.ShortArrayTag;
import io.github.lxgaming.binary.tag.ShortTag;
import io.github.lxgaming.binary.tag.StringTag;
import io.github.lxgaming.binary.tag.Tag;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class CompoundTag
implements CollectionTag {
    private final Map<String, Tag> tags;

    public CompoundTag() {
        this(new HashMap<String, Tag>());
    }

    public CompoundTag(@NonNull Map<String, Tag> tags) {
        this.tags = tags;
    }

    public boolean contains(@NonNull String key) {
        return this.tags.containsKey(key);
    }

    public @Nullable Tag get(@NonNull String key) {
        return this.tags.get(key);
    }

    public void put(@NonNull String key, @NonNull Tag tag) {
        this.tags.put(key, tag);
    }

    public void remove(@NonNull String key) {
        this.tags.remove(key);
    }

    public void clear() {
        this.tags.clear();
    }

    public @NonNull Set<String> keySet() {
        return this.tags.keySet();
    }

    public @NonNull Collection<Tag> values() {
        return this.tags.values();
    }

    public @NonNull Set<Map.Entry<String, Tag>> entrySet() {
        return this.tags.entrySet();
    }

    public boolean getBoolean(@NonNull String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(@NonNull String key, boolean defaultValue) {
        Tag tag = this.tags.get(key);
        return tag instanceof BooleanTag ? ((BooleanTag)tag).getValue() : defaultValue;
    }

    public void putBoolean(@NonNull String key, boolean value) {
        this.tags.put(key, new BooleanTag(value));
    }

    public byte getByte(@NonNull String key) {
        return this.getByte(key, (byte)0);
    }

    public byte getByte(@NonNull String key, byte defaultValue) {
        Tag tag = this.tags.get(key);
        return tag instanceof ByteTag ? ((ByteTag)tag).getValue() : defaultValue;
    }

    public void putByte(@NonNull String key, byte value) {
        this.tags.put(key, new ByteTag(value));
    }

    public short getShort(@NonNull String key) {
        return this.getShort(key, (short)0);
    }

    public short getShort(@NonNull String key, short defaultValue) {
        Tag tag = this.tags.get(key);
        return tag instanceof ShortTag ? ((ShortTag)tag).getValue() : defaultValue;
    }

    public void putShort(@NonNull String key, short value) {
        this.tags.put(key, new ShortTag(value));
    }

    public int getInt(@NonNull String key) {
        return this.getInt(key, 0);
    }

    public int getInt(@NonNull String key, int defaultValue) {
        Tag tag = this.tags.get(key);
        return tag instanceof IntTag ? ((IntTag)tag).getValue() : defaultValue;
    }

    public void putInt(@NonNull String key, int value) {
        this.tags.put(key, new IntTag(value));
    }

    public long getLong(@NonNull String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(@NonNull String key, long defaultValue) {
        Tag tag = this.tags.get(key);
        return tag instanceof LongTag ? ((LongTag)tag).getValue() : defaultValue;
    }

    public void putLong(@NonNull String key, long value) {
        this.tags.put(key, new LongTag(value));
    }

    public float getFloat(@NonNull String key) {
        return this.getFloat(key, 0.0f);
    }

    public float getFloat(@NonNull String key, float defaultValue) {
        Tag tag = this.tags.get(key);
        return tag instanceof FloatTag ? ((FloatTag)tag).getValue() : defaultValue;
    }

    public void putFloat(@NonNull String key, float value) {
        this.tags.put(key, new FloatTag(value));
    }

    public double getDouble(@NonNull String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(@NonNull String key, double defaultValue) {
        Tag tag = this.tags.get(key);
        return tag instanceof DoubleTag ? ((DoubleTag)tag).getValue() : defaultValue;
    }

    public void putDouble(@NonNull String key, double value) {
        this.tags.put(key, new DoubleTag(value));
    }

    public byte @NonNull [] getByteArray(@NonNull String key) {
        Tag tag = this.tags.get(key);
        return tag instanceof ByteArrayTag ? ((ByteArrayTag)tag).getValue() : new byte[]{};
    }

    public byte @NonNull [] getByteArray(@NonNull String key, byte @NonNull [] defaultValue) {
        Tag tag = this.tags.get(key);
        return tag instanceof ByteArrayTag ? ((ByteArrayTag)tag).getValue() : defaultValue;
    }

    public void putByteArray(@NonNull String key, byte @NonNull [] value) {
        this.tags.put(key, new ByteArrayTag(value));
    }

    public @NonNull String getString(@NonNull String key) {
        return this.getString(key, "");
    }

    public @NonNull String getString(@NonNull String key, @NonNull String defaultValue) {
        Tag tag = this.tags.get(key);
        return tag instanceof StringTag ? ((StringTag)tag).getValue() : defaultValue;
    }

    public void putString(@NonNull String key, @NonNull String value) {
        this.tags.put(key, new StringTag(value));
    }

    public short @NonNull [] getShortArray(@NonNull String key) {
        Tag tag = this.tags.get(key);
        return tag instanceof ShortArrayTag ? ((ShortArrayTag)tag).getValue() : new short[]{};
    }

    public short @NonNull [] getShortArray(@NonNull String key, short @NonNull [] defaultValue) {
        Tag tag = this.tags.get(key);
        return tag instanceof ShortArrayTag ? ((ShortArrayTag)tag).getValue() : defaultValue;
    }

    public void putShortArray(@NonNull String key, short @NonNull [] value) {
        this.tags.put(key, new ShortArrayTag(value));
    }

    public int @NonNull [] getIntArray(@NonNull String key) {
        Tag tag = this.tags.get(key);
        return tag instanceof IntArrayTag ? ((IntArrayTag)tag).getValue() : new int[]{};
    }

    public int @NonNull [] getIntArray(@NonNull String key, int @NonNull [] defaultValue) {
        Tag tag = this.tags.get(key);
        return tag instanceof IntArrayTag ? ((IntArrayTag)tag).getValue() : defaultValue;
    }

    public void putIntArray(@NonNull String key, int @NonNull [] value) {
        this.tags.put(key, new IntArrayTag(value));
    }

    public long @NonNull [] getLongArray(@NonNull String key) {
        Tag tag = this.tags.get(key);
        return tag instanceof LongArrayTag ? ((LongArrayTag)tag).getValue() : new long[]{};
    }

    public long @NonNull [] getLongArray(@NonNull String key, long @NonNull [] defaultValue) {
        Tag tag = this.tags.get(key);
        return tag instanceof LongArrayTag ? ((LongArrayTag)tag).getValue() : defaultValue;
    }

    public void putLongArray(@NonNull String key, long @NonNull [] value) {
        this.tags.put(key, new LongArrayTag(value));
    }

    public float @NonNull [] getFloatArray(@NonNull String key) {
        Tag tag = this.tags.get(key);
        return tag instanceof FloatArrayTag ? ((FloatArrayTag)tag).getValue() : new float[]{};
    }

    public float @NonNull [] getFloatArray(@NonNull String key, float @NonNull [] defaultValue) {
        Tag tag = this.tags.get(key);
        return tag instanceof FloatArrayTag ? ((FloatArrayTag)tag).getValue() : defaultValue;
    }

    public void putFloatArray(@NonNull String key, float @NonNull [] value) {
        this.tags.put(key, new FloatArrayTag(value));
    }

    public double @NonNull [] getDoubleArray(@NonNull String key) {
        Tag tag = this.tags.get(key);
        return tag instanceof DoubleArrayTag ? ((DoubleArrayTag)tag).getValue() : new double[]{};
    }

    public double @NonNull [] getDoubleArray(@NonNull String key, double @NonNull [] defaultValue) {
        Tag tag = this.tags.get(key);
        return tag instanceof DoubleArrayTag ? ((DoubleArrayTag)tag).getValue() : defaultValue;
    }

    public void putDoubleArray(@NonNull String key, double @NonNull [] value) {
        this.tags.put(key, new DoubleArrayTag(value));
    }

    public @NonNull ListTag getList(@NonNull String key) {
        Tag tag = this.tags.get(key);
        return tag instanceof ListTag ? (ListTag)tag : new ListTag();
    }

    public @NonNull ListTag getList(@NonNull String key, @NonNull ListTag defaultValue) {
        Tag tag = this.tags.get(key);
        return tag instanceof ListTag ? (ListTag)tag : defaultValue;
    }

    public @NonNull ListTag getList(@NonNull String key, @NonNull Class<? extends Tag> type) {
        ListTag list;
        Tag tag = this.tags.get(key);
        if (tag instanceof ListTag && (list = (ListTag)tag).getType() == type) {
            return list;
        }
        return new ListTag();
    }

    public @NonNull ListTag getList(@NonNull String key, @NonNull Class<? extends Tag> type, @NonNull ListTag defaultValue) {
        ListTag list;
        Tag tag = this.tags.get(key);
        if (tag instanceof ListTag && (list = (ListTag)tag).getType() == type) {
            return list;
        }
        return defaultValue;
    }

    public void putList(@NonNull String key, @NonNull ListTag value) {
        this.tags.put(key, value);
    }

    public @NonNull CompoundTag getCompound(@NonNull String key) {
        Tag tag = this.tags.get(key);
        return tag instanceof CompoundTag ? (CompoundTag)tag : new CompoundTag();
    }

    public @NonNull CompoundTag getCompound(@NonNull String key, @NonNull CompoundTag defaultValue) {
        Tag tag = this.tags.get(key);
        return tag instanceof CompoundTag ? (CompoundTag)tag : defaultValue;
    }

    public void putCompound(@NonNull String key, @NonNull CompoundTag value) {
        this.tags.put(key, value);
    }

    @Override
    public int size() {
        return this.tags.size();
    }

    @Override
    public boolean isEmpty() {
        return this.tags.isEmpty();
    }

    @Override
    public @NonNull CompoundTag copy() {
        CompoundTag compound = new CompoundTag();
        for (Map.Entry<String, Tag> entry : this.tags.entrySet()) {
            compound.put(entry.getKey(), entry.getValue().copy());
        }
        return compound;
    }

    @Override
    public int hashCode() {
        return this.tags.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof CompoundTag && this.tags.equals(((CompoundTag)obj).tags);
    }
}

