/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.binary.tag;

import io.github.lxgaming.binary.tag.CollectionTag;
import java.util.Arrays;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class DoubleArrayTag
implements CollectionTag {
    private double[] value;

    public DoubleArrayTag() {
        this(new double[0]);
    }

    public DoubleArrayTag(double @NonNull [] value) {
        this.value = value;
    }

    public double @NonNull [] getValue() {
        return this.value;
    }

    public void setValue(double @NonNull [] value) {
        this.value = value;
    }

    public double get(@NonNegative int index) {
        return this.value[index];
    }

    public void set(@NonNegative int index, double value) {
        this.value[index] = value;
    }

    @Override
    public int size() {
        return this.value.length;
    }

    @Override
    public @NonNull DoubleArrayTag copy() {
        double[] value = new double[this.value.length];
        System.arraycopy(this.value, 0, value, 0, value.length);
        return new DoubleArrayTag(value);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof DoubleArrayTag && Arrays.equals(this.value, ((DoubleArrayTag)obj).value);
    }
}

