/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.binary.tag;

import io.github.lxgaming.binary.tag.CollectionTag;
import io.github.lxgaming.binary.tag.Tag;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ListTag
implements CollectionTag,
Iterable<Tag> {
    private final List<Tag> tags;
    private Class<? extends Tag> type;

    public ListTag() {
        this(Tag.class);
    }

    public ListTag(@NonNull Class<? extends Tag> type) {
        this(new ArrayList<Tag>(), type);
    }

    public ListTag(@NonNull List<Tag> tags, @NonNull Class<? extends Tag> type) {
        this.tags = tags;
        this.type = type;
    }

    public boolean contains(@NonNull Tag tag) {
        return this.tags.contains(tag);
    }

    public @NonNull Tag get(@NonNegative int index) {
        return this.tags.get(index);
    }

    public boolean add(@NonNull Tag tag) {
        this.checkType(tag.getClass());
        return this.tags.add(tag);
    }

    public void add(@NonNegative int index, @NonNull Tag tag) {
        this.checkType(tag.getClass());
        this.tags.add(index, tag);
    }

    public @NonNull Tag set(@NonNegative int index, @NonNull Tag tag) {
        this.checkType(tag.getClass());
        return this.tags.set(index, tag);
    }

    public boolean remove(@NonNull Tag tag) {
        return this.tags.remove(tag);
    }

    public @NonNull Tag remove(@NonNegative int index) {
        return this.tags.remove(index);
    }

    public void clear() {
        this.tags.clear();
    }

    public @NonNull Class<? extends Tag> getType() {
        return this.type;
    }

    private void checkType(@NonNull Class<? extends Tag> type) {
        if (this.type == Tag.class) {
            this.type = type;
        }
        if (this.type != type) {
            throw new IllegalArgumentException(String.format("Trying to add tag of type %s to list of %s", type, this.type));
        }
    }

    @Override
    public @NonNull Iterator<Tag> iterator() {
        return this.tags.iterator();
    }

    @Override
    public int size() {
        return this.tags.size();
    }

    @Override
    public boolean isEmpty() {
        return this.tags.isEmpty();
    }

    @Override
    public @NonNull ListTag copy() {
        ListTag list = new ListTag(this.type);
        for (Tag tag : this.tags) {
            list.tags.add(tag.copy());
        }
        return list;
    }

    @Override
    public int hashCode() {
        return this.tags.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof ListTag && this.tags.equals(((ListTag)obj).tags);
    }
}

