/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.binary.serializer.msgpack;

import io.github.lxgaming.binary.BinarySerializer;
import io.github.lxgaming.binary.serializer.msgpack.MessageBufferPackerImpl;
import io.github.lxgaming.binary.serializer.msgpack.MessagePackerImpl;
import io.github.lxgaming.binary.tag.BooleanTag;
import io.github.lxgaming.binary.tag.ByteArrayTag;
import io.github.lxgaming.binary.tag.ByteTag;
import io.github.lxgaming.binary.tag.CollectionTag;
import io.github.lxgaming.binary.tag.CompoundTag;
import io.github.lxgaming.binary.tag.DoubleArrayTag;
import io.github.lxgaming.binary.tag.DoubleTag;
import io.github.lxgaming.binary.tag.FloatArrayTag;
import io.github.lxgaming.binary.tag.FloatTag;
import io.github.lxgaming.binary.tag.IntArrayTag;
import io.github.lxgaming.binary.tag.IntTag;
import io.github.lxgaming.binary.tag.ListTag;
import io.github.lxgaming.binary.tag.LongArrayTag;
import io.github.lxgaming.binary.tag.LongTag;
import io.github.lxgaming.binary.tag.ShortArrayTag;
import io.github.lxgaming.binary.tag.ShortTag;
import io.github.lxgaming.binary.tag.StringTag;
import io.github.lxgaming.binary.tag.Tag;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.msgpack.core.ExtensionTypeHeader;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.core.MessageFormat;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.core.buffer.MessageBufferOutput;
import org.msgpack.core.buffer.OutputStreamBufferOutput;
import org.msgpack.value.ValueType;

public class MessagePackSerializer
implements BinarySerializer {
    public static final byte ARRAY_ID = 0;
    public static final byte LIST_ID = 1;
    protected final MessagePack.PackerConfig packerConfig;
    protected final MessagePack.UnpackerConfig unpackerConfig;

    public MessagePackSerializer() {
        this(MessagePack.DEFAULT_PACKER_CONFIG, MessagePack.DEFAULT_UNPACKER_CONFIG);
    }

    public MessagePackSerializer(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull MessagePack.PackerConfig packerConfig, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull MessagePack.UnpackerConfig unpackerConfig) {
        this.packerConfig = packerConfig;
        this.unpackerConfig = unpackerConfig;
    }

    public @NonNull Tag read(@NonNull InputStream input) throws IOException {
        try (MessageUnpacker unpacker = this.unpackerConfig.newUnpacker(input);){
            Tag tag = this.read(unpacker);
            return tag;
        }
    }

    public void write(@NonNull OutputStream output, @NonNull Tag tag) throws IOException {
        try (MessagePackerImpl packer = new MessagePackerImpl((MessageBufferOutput)new OutputStreamBufferOutput(output), this.packerConfig);){
            this.write(packer, tag);
        }
    }

    public @NonNull Tag read(@NonNull MessageUnpacker unpacker) throws IOException {
        MessageFormat format = unpacker.getNextFormat();
        ValueType type = format.getValueType();
        if (format == MessageFormat.BOOLEAN) {
            return new BooleanTag(unpacker.unpackBoolean());
        }
        if (format == MessageFormat.POSFIXINT || format == MessageFormat.UINT8 || format == MessageFormat.INT8 || format == MessageFormat.NEGFIXINT) {
            return new ByteTag(unpacker.unpackByte());
        }
        if (format == MessageFormat.UINT16 || format == MessageFormat.INT16) {
            return new ShortTag(unpacker.unpackShort());
        }
        if (format == MessageFormat.UINT32 || format == MessageFormat.INT32) {
            return new IntTag(unpacker.unpackInt());
        }
        if (format == MessageFormat.UINT64 || format == MessageFormat.INT64) {
            return new LongTag(unpacker.unpackLong());
        }
        if (format == MessageFormat.FLOAT32) {
            return new FloatTag(unpacker.unpackFloat());
        }
        if (format == MessageFormat.FLOAT64) {
            return new DoubleTag(unpacker.unpackDouble());
        }
        if (type.isStringType()) {
            return new StringTag(unpacker.unpackString());
        }
        if (type.isArrayType()) {
            return this.readArray(unpacker);
        }
        if (type.isMapType()) {
            return this.readCompound(unpacker);
        }
        if (type.isExtensionType()) {
            return this.readExtension(unpacker);
        }
        throw new UnsupportedOperationException(String.format("%s is not supported", format));
    }

    public void write(@NonNull MessagePacker packer, @NonNull Tag tag) throws IOException {
        if (tag instanceof BooleanTag) {
            packer.packBoolean(((BooleanTag)tag).getValue());
        } else if (tag instanceof ByteTag) {
            packer.packByte(((ByteTag)tag).getValue());
        } else if (tag instanceof ShortTag) {
            packer.packShort(((ShortTag)tag).getValue());
        } else if (tag instanceof IntTag) {
            packer.packInt(((IntTag)tag).getValue());
        } else if (tag instanceof LongTag) {
            packer.packLong(((LongTag)tag).getValue());
        } else if (tag instanceof FloatTag) {
            packer.packFloat(((FloatTag)tag).getValue());
        } else if (tag instanceof DoubleTag) {
            packer.packDouble(((DoubleTag)tag).getValue());
        } else if (tag instanceof StringTag) {
            packer.packString(((StringTag)tag).getValue());
        } else if (tag instanceof CollectionTag) {
            this.writeCollection(packer, (CollectionTag)tag);
        } else {
            throw new UnsupportedOperationException(String.format("%s is not supported", tag.getClass().getName()));
        }
    }

    protected CollectionTag readArray(@NonNull MessageUnpacker unpacker) throws IOException {
        byte code = unpacker.unpackByte();
        int size = unpacker.unpackArrayHeader();
        if (code == -48) {
            ByteArrayTag tag = new ByteArrayTag(new byte[size]);
            for (int index = 0; index < size; ++index) {
                tag.set(index, unpacker.unpackByte());
            }
            return tag;
        }
        if (code == -47) {
            ShortArrayTag tag = new ShortArrayTag(new short[size]);
            for (int index = 0; index < size; ++index) {
                tag.set(index, unpacker.unpackShort());
            }
            return tag;
        }
        if (code == -46) {
            IntArrayTag tag = new IntArrayTag(new int[size]);
            for (int index = 0; index < size; ++index) {
                tag.set(index, unpacker.unpackInt());
            }
            return tag;
        }
        if (code == -45) {
            LongArrayTag tag = new LongArrayTag(new long[size]);
            for (int index = 0; index < size; ++index) {
                tag.set(index, unpacker.unpackLong());
            }
            return tag;
        }
        if (code == -54) {
            FloatArrayTag tag = new FloatArrayTag(new float[size]);
            for (int index = 0; index < size; ++index) {
                tag.set(index, unpacker.unpackFloat());
            }
            return tag;
        }
        if (code == -53) {
            DoubleArrayTag tag = new DoubleArrayTag(new double[size]);
            for (int index = 0; index < size; ++index) {
                tag.set(index, unpacker.unpackDouble());
            }
            return tag;
        }
        throw new UnsupportedOperationException(String.format("%s is not supported", code));
    }

    protected void writeCollection(@NonNull MessagePacker packer, @NonNull CollectionTag collection) throws IOException {
        if (collection instanceof ByteArrayTag) {
            MessageBufferPacker arrayPacker = this.packerConfig.newBufferPacker();
            arrayPacker.packByte((byte)-48);
            arrayPacker.packArrayHeader(collection.size());
            for (byte value : ((ByteArrayTag)collection).getValue()) {
                arrayPacker.packByte(value);
            }
            this.writeExtension(packer, (byte)0, arrayPacker.toByteArray());
        } else if (collection instanceof ShortArrayTag) {
            MessageBufferPacker arrayPacker = this.packerConfig.newBufferPacker();
            arrayPacker.packByte((byte)-47);
            arrayPacker.packArrayHeader(collection.size());
            for (short value : ((ShortArrayTag)collection).getValue()) {
                arrayPacker.packShort(value);
            }
            this.writeExtension(packer, (byte)0, arrayPacker.toByteArray());
        } else if (collection instanceof IntArrayTag) {
            MessageBufferPacker arrayPacker = this.packerConfig.newBufferPacker();
            arrayPacker.packByte((byte)-46);
            arrayPacker.packArrayHeader(collection.size());
            for (int value : ((IntArrayTag)collection).getValue()) {
                arrayPacker.packInt(value);
            }
            this.writeExtension(packer, (byte)0, arrayPacker.toByteArray());
        } else if (collection instanceof LongArrayTag) {
            MessageBufferPacker arrayPacker = this.packerConfig.newBufferPacker();
            arrayPacker.packByte((byte)-45);
            arrayPacker.packArrayHeader(collection.size());
            for (long value : ((LongArrayTag)collection).getValue()) {
                arrayPacker.packLong(value);
            }
            this.writeExtension(packer, (byte)0, arrayPacker.toByteArray());
        } else if (collection instanceof FloatArrayTag) {
            MessageBufferPacker arrayPacker = this.packerConfig.newBufferPacker();
            arrayPacker.packByte((byte)-54);
            arrayPacker.packArrayHeader(collection.size());
            for (float value : ((FloatArrayTag)collection).getValue()) {
                arrayPacker.packFloat(value);
            }
            this.writeExtension(packer, (byte)0, arrayPacker.toByteArray());
        } else if (collection instanceof DoubleArrayTag) {
            MessageBufferPacker arrayPacker = this.packerConfig.newBufferPacker();
            arrayPacker.packByte((byte)-53);
            arrayPacker.packArrayHeader(collection.size());
            for (double value : ((DoubleArrayTag)collection).getValue()) {
                arrayPacker.packDouble(value);
            }
            this.writeExtension(packer, (byte)0, arrayPacker.toByteArray());
        } else if (collection instanceof CompoundTag) {
            this.writeCompound(packer, (CompoundTag)collection);
        } else if (collection instanceof ListTag) {
            MessageBufferPackerImpl listPacker = new MessageBufferPackerImpl(this.packerConfig);
            this.writeList((MessagePacker)listPacker, (ListTag)collection);
            this.writeExtension(packer, (byte)1, listPacker.toByteArray());
        } else {
            throw new UnsupportedOperationException(String.format("%s is not supported", collection.getClass().getName()));
        }
    }

    protected CompoundTag readCompound(@NonNull MessageUnpacker unpacker) throws IOException {
        int size = unpacker.unpackMapHeader();
        CompoundTag compound = new CompoundTag();
        for (int index = 0; index < size; ++index) {
            String key = unpacker.unpackString();
            Tag value = this.read(unpacker);
            compound.put(key, value);
        }
        return compound;
    }

    protected void writeCompound(@NonNull MessagePacker packer, @NonNull CompoundTag compound) throws IOException {
        packer.packMapHeader(compound.size());
        for (Map.Entry entry : compound.entrySet()) {
            packer.packString((String)entry.getKey());
            this.write(packer, (Tag)entry.getValue());
        }
    }

    protected CollectionTag readExtension(@NonNull MessageUnpacker unpacker) throws IOException {
        ExtensionTypeHeader header = unpacker.unpackExtensionTypeHeader();
        byte[] bytes = unpacker.readPayload(header.getLength());
        MessageUnpacker extensionPacker = this.unpackerConfig.newUnpacker(bytes);
        if (header.getType() == 0) {
            return this.readArray(extensionPacker);
        }
        if (header.getType() == 1) {
            return this.readList(extensionPacker);
        }
        throw new UnsupportedOperationException(String.format("%s is not supported", header.getType()));
    }

    protected void writeExtension(@NonNull MessagePacker packer, byte extensionType, byte[] bytes) throws IOException {
        packer.packExtensionTypeHeader(extensionType, bytes.length);
        packer.addPayload(bytes);
    }

    protected ListTag readList(@NonNull MessageUnpacker unpacker) throws IOException {
        int size = unpacker.unpackArrayHeader();
        ListTag list = new ListTag();
        for (int index = 0; index < size; ++index) {
            Tag tag = this.read(unpacker);
            list.add(tag);
        }
        return list;
    }

    protected void writeList(@NonNull MessagePacker packer, @NonNull ListTag list) throws IOException {
        packer.packArrayHeader(list.size());
        for (Tag tag : list) {
            this.write(packer, tag);
        }
    }
}

