/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.binary.serializer.msgpack;

import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import org.msgpack.core.MessagePacker;

public class MessagePackerUtils {
    private static MethodHandle writeByteAndShort;
    private static MethodHandle writeByteAndInt;
    private static MethodHandle writeByteAndLong;

    public static MessagePacker packShort(MessagePacker packer, short value) throws IOException {
        try {
            if (value < 0) {
                writeByteAndShort.invoke(packer, (byte)-47, value);
            } else {
                writeByteAndShort.invoke(packer, (byte)-51, value);
            }
            return packer;
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static MessagePacker packInt(MessagePacker packer, int value) throws IOException {
        try {
            if (value < 0) {
                writeByteAndInt.invoke(packer, (byte)-46, value);
            } else {
                writeByteAndInt.invoke(packer, (byte)-50, value);
            }
            return packer;
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static MessagePacker packLong(MessagePacker packer, long value) throws IOException {
        try {
            if (value < 0L) {
                writeByteAndLong.invoke(packer, (byte)-45, value);
            } else {
                writeByteAndLong.invoke(packer, (byte)-49, value);
            }
            return packer;
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            Method writeByteAndShortMethod = MessagePacker.class.getDeclaredMethod("writeByteAndShort", Byte.TYPE, Short.TYPE);
            writeByteAndShortMethod.setAccessible(true);
            writeByteAndShort = lookup.unreflect(writeByteAndShortMethod);
            Method writeByteAndIntMethod = MessagePacker.class.getDeclaredMethod("writeByteAndInt", Byte.TYPE, Integer.TYPE);
            writeByteAndIntMethod.setAccessible(true);
            writeByteAndInt = lookup.unreflect(writeByteAndIntMethod);
            Method writeByteAndLongMethod = MessagePacker.class.getDeclaredMethod("writeByteAndLong", Byte.TYPE, Long.TYPE);
            writeByteAndLongMethod.setAccessible(true);
            writeByteAndLong = lookup.unreflect(writeByteAndLongMethod);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

