/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.code.api;

import java.util.Objects;

public final class CodeName {
    private final char separator;
    private final String simpleName;
    private final String fullName;
    private final int lastSeparatorIndex;
    private CodeName parent;

    public CodeName(String qualifiedName, char separator) {
        this.separator = separator;
        Objects.requireNonNull(qualifiedName, "qualifiedName");
        this.fullName = qualifiedName;
        this.lastSeparatorIndex = qualifiedName.lastIndexOf(separator);
        this.simpleName = this.lastSeparatorIndex > 0 ? qualifiedName.substring(this.lastSeparatorIndex + 1) : qualifiedName;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public CodeName getParent() {
        if (this.parent == null && this.lastSeparatorIndex > 0) {
            String parentName = this.fullName.substring(0, this.lastSeparatorIndex);
            this.parent = new CodeName(parentName, this.separator);
        }
        return this.parent;
    }

    public String toString() {
        return this.fullName;
    }
}

