/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.code.api.doc;

import io.github.mmm.code.api.doc.CodeDocLink;
import io.github.mmm.code.api.doc.Tag;
import java.util.function.Supplier;

public abstract class CodeDocFormat {
    public static final CodeDocFormat HTML = new CodeDocFormatHtml();
    public static final CodeDocFormat ASCII_DOC = new CodeDocFormatAsciiDoc();
    public static final CodeDocFormat PLAIN_TEXT = new CodeDocFormatPlainText();
    public static final CodeDocFormat RAW = new CodeDocFormatRaw();
    private static final String CODE_START = "<code>";
    private static final String CODE_END = "</code>";

    public abstract boolean isReplaceXmlTags();

    public abstract String replaceXmlTag(Tag var1);

    public abstract String replaceDocTag(String var1, Supplier<CodeDocLink> var2, String var3);

    public abstract String toString();

    private static int getListLevel(Tag tag) {
        Tag parent = tag.getParent();
        if (parent == null) {
            return 0;
        }
        int level = CodeDocFormat.getListLevel(parent);
        String name = tag.getName();
        if (name.equals("ul")) {
            if (level == 0) {
                level = -1;
            } else if (level > 0) {
                level = -level;
            }
        } else if (name.equals("ol")) {
            if (level == 0) {
                level = 1;
            } else if (level < 0) {
                level = -level;
            }
        } else if (name.equals("li")) {
            level = level > 0 ? ++level : --level;
        }
        return level;
    }

    protected static class CodeDocFormatHtml
    extends CodeDocFormat {
        protected CodeDocFormatHtml() {
        }

        @Override
        public boolean isReplaceXmlTags() {
            return false;
        }

        @Override
        public String replaceXmlTag(Tag tag) {
            throw new IllegalStateException();
        }

        @Override
        public String replaceDocTag(String tag, Supplier<CodeDocLink> link, String text) {
            StringBuilder buffer = new StringBuilder(text.length() + 16);
            if ("link".equals(tag)) {
                buffer.append(CodeDocFormat.CODE_START);
                this.appendLink(buffer, link.get(), text);
                buffer.append(CodeDocFormat.CODE_END);
            } else if ("linkplain".equals(tag)) {
                this.appendLink(buffer, link.get(), text);
            } else if ("code".equals(tag)) {
                buffer.append(CodeDocFormat.CODE_START);
                this.appendText(buffer, text);
                buffer.append(CodeDocFormat.CODE_END);
            } else if ("literal".equals(tag)) {
                this.appendText(buffer, text);
            } else if ("value".equals(tag)) {
                this.appendValue(buffer, link.get());
            } else {
                this.appendText(buffer, text);
            }
            return buffer.toString();
        }

        private void appendValue(StringBuilder buffer, CodeDocLink link) {
            buffer.append(CodeDocFormat.CODE_START);
            this.appendText(buffer, link.getLinkedValueAsString());
            buffer.append(CodeDocFormat.CODE_END);
        }

        private void appendLink(StringBuilder buffer, CodeDocLink link, String text) {
            buffer.append("<a href='");
            buffer.append(link.getLinkUrl());
            buffer.append("'>");
            this.appendText(buffer, link.getText());
            buffer.append("</a>");
        }

        private void appendText(StringBuilder buffer, String text) {
            if (text == null || text.isEmpty()) {
                return;
            }
            this.escapeXml(text.trim(), buffer, false);
        }

        private void escapeXml(String string, StringBuilder writer, boolean escapeQuotations) {
            char[] chars;
            if (string == null) {
                writer.append("null");
                return;
            }
            for (char c : chars = string.toCharArray()) {
                if (c >= '\u0080') {
                    writer.append("&#");
                    writer.append(Integer.toString(c));
                    writer.append(";");
                    continue;
                }
                if (c == '&') {
                    writer.append("&amp;");
                    continue;
                }
                if (c == '<') {
                    writer.append("&lt;");
                    continue;
                }
                if (c == '>') {
                    writer.append("&gt;");
                    continue;
                }
                if (escapeQuotations && c == '\'') {
                    writer.append("&#39;");
                    continue;
                }
                if (escapeQuotations && c == '\"') {
                    writer.append("&quot;");
                    continue;
                }
                writer.append(c);
            }
        }

        @Override
        public String toString() {
            return "html";
        }
    }

    protected static class CodeDocFormatAsciiDoc
    extends CodeDocFormat {
        protected CodeDocFormatAsciiDoc() {
        }

        @Override
        public boolean isReplaceXmlTags() {
            return true;
        }

        @Override
        public String replaceXmlTag(Tag tag) {
            String name = tag.getName();
            if (tag.isOpening() && tag.isClosing()) {
                if ("br".equals(name)) {
                    return "\n";
                }
                if ("p".equals(name)) {
                    return "\n<<<<\n";
                }
                if ("hr".equals(name)) {
                    return "\n'''\n";
                }
                return "";
            }
            if ("code".equals(name)) {
                return "`";
            }
            if ("b".equals(name) || "strong".equals(name)) {
                return "*";
            }
            if ("i".equals(name) || "em".equals(name)) {
                return "_";
            }
            if (tag.getName().equals("ol") || tag.getName().equals("ul")) {
                return "\n";
            }
            if (tag.isOpening() && !tag.isClosing()) {
                if ("li".equals(name)) {
                    if (tag.isOpening()) {
                        String bullet;
                        int level = CodeDocFormat.getListLevel(tag);
                        int indent = level;
                        if (indent < 0) {
                            indent = -indent;
                            bullet = "*";
                        } else {
                            bullet = ".";
                        }
                        StringBuilder buffer = new StringBuilder(indent + 2);
                        buffer.append('\n');
                        for (int i = 0; i < indent; ++i) {
                            buffer.append(bullet);
                        }
                        buffer.append(' ');
                        return buffer.toString();
                    }
                } else {
                    if ("h1".equals(name)) {
                        return "\n= ";
                    }
                    if ("h2".equals(name)) {
                        return "\n== ";
                    }
                    if ("h3".equals(name)) {
                        return "\n=== ";
                    }
                    if ("h4".equals(name)) {
                        return "\n==== ";
                    }
                }
            }
            return "";
        }

        @Override
        public String replaceDocTag(String tag, Supplier<CodeDocLink> link, String text) {
            StringBuilder buffer = new StringBuilder(text.length() + 16);
            if ("link".equals(tag)) {
                buffer.append('`');
                this.appendLink(buffer, link.get(), text);
                buffer.append('`');
            } else if ("linkplain".equals(tag)) {
                this.appendLink(buffer, link.get(), text);
            } else if ("code".equals(tag)) {
                buffer.append('`');
                this.appendText(buffer, text);
                buffer.append('`');
            } else if ("literal".equals(tag)) {
                this.appendText(buffer, text);
            } else if ("value".equals(tag)) {
                this.appendValue(buffer, link.get());
            } else {
                this.appendText(buffer, text);
            }
            return buffer.toString();
        }

        private void appendValue(StringBuilder buffer, CodeDocLink link) {
            buffer.append('`');
            this.appendText(buffer, link.getLinkedValueAsString());
            buffer.append('`');
        }

        private void appendLink(StringBuilder buffer, CodeDocLink link, String text) {
            String url = link.getLinkUrl();
            if (!url.contains("://")) {
                buffer.append("link:");
            }
            buffer.append(url);
            buffer.append('[');
            this.appendText(buffer, link.getText());
            buffer.append(']');
        }

        private void appendText(StringBuilder buffer, String text) {
            if (text == null || text.isEmpty()) {
                return;
            }
            buffer.append(text.trim());
        }

        @Override
        public String toString() {
            return "ascii-doc";
        }
    }

    protected static class CodeDocFormatPlainText
    extends CodeDocFormat {
        protected CodeDocFormatPlainText() {
        }

        @Override
        public boolean isReplaceXmlTags() {
            return true;
        }

        @Override
        public String replaceXmlTag(Tag tag) {
            if (tag.getName().equals("li")) {
                if (tag.isOpening()) {
                    String bullet;
                    int level = CodeDocFormat.getListLevel(tag);
                    int indent = level;
                    if (indent < 0) {
                        indent = -indent;
                        bullet = "* ";
                    } else {
                        bullet = ". ";
                    }
                    StringBuilder buffer = new StringBuilder(2 * (indent - 1) + 3);
                    buffer.append('\n');
                    for (int i = 1; i < indent; ++i) {
                        buffer.append("  ");
                    }
                    buffer.append(bullet);
                    return buffer.toString();
                }
            } else if (tag.isClosing() && (tag.getName().equals("ol") || tag.getName().equals("ul"))) {
                return "\n";
            }
            return "";
        }

        @Override
        public String replaceDocTag(String tag, Supplier<CodeDocLink> link, String text) {
            if (link != null) {
                return link.get().getText();
            }
            return text;
        }

        @Override
        public String toString() {
            return "plain-text";
        }
    }

    protected static class CodeDocFormatRaw
    extends CodeDocFormat {
        protected CodeDocFormatRaw() {
        }

        @Override
        public boolean isReplaceXmlTags() {
            return false;
        }

        @Override
        public String replaceXmlTag(Tag tag) {
            throw new IllegalStateException();
        }

        @Override
        public String replaceDocTag(String tag, Supplier<CodeDocLink> link, String text) {
            throw new IllegalStateException();
        }

        @Override
        public String toString() {
            return "raw";
        }
    }
}

