/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.code.api.doc;

import io.github.mmm.code.api.doc.Tag;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XmlTag
implements Tag {
    private static final Pattern PATTERN_ATTRIBUTE = Pattern.compile("([a-zA-Z_][a-zA-Z0-9:._-]*)(='[^']*'|=\"[^\"]*\"|)");
    private final String name;
    private final boolean opening;
    private final boolean closing;
    private final String attributes;
    private final Tag parent;
    private Map<String, String> attributesMap;

    public XmlTag(String name, boolean opening, boolean closing, String attributes, Tag parent) {
        this.name = name;
        this.opening = opening;
        this.closing = closing;
        this.attributes = attributes == null ? "" : attributes.trim();
        this.parent = parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isOpening() {
        return this.opening;
    }

    @Override
    public boolean isClosing() {
        return this.closing;
    }

    @Override
    public Tag getParent() {
        return this.parent;
    }

    @Override
    public String getAttributes() {
        return this.attributes;
    }

    @Override
    public Map<String, String> getAttributesAsMap() {
        if (this.attributesMap == null) {
            if (this.attributes.isEmpty()) {
                this.attributesMap = Collections.emptyMap();
            } else {
                HashMap<String, String> map = new HashMap<String, String>();
                Matcher matcher = PATTERN_ATTRIBUTE.matcher(this.attributes);
                while (matcher.find()) {
                    String key = matcher.group(1);
                    String value = matcher.group(2);
                    map.put(key, value);
                }
                this.attributesMap = map;
            }
        }
        return this.attributesMap;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('<');
        if (this.isClosing() && !this.isOpening()) {
            buffer.append('/');
        }
        buffer.append(this.name);
        if (!this.attributes.isEmpty()) {
            buffer.append(' ');
            buffer.append(this.attributes);
        }
        if (this.isClosing() && this.isOpening()) {
            buffer.append('/');
        }
        buffer.append('>');
        return buffer.toString();
    }
}

