/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.code.api.language;

import io.github.mmm.base.exception.ObjectMismatchException;
import io.github.mmm.code.api.CodeFile;
import io.github.mmm.code.api.CodePackage;
import io.github.mmm.code.api.annotation.CodeAnnotations;
import io.github.mmm.code.api.arg.CodeParameters;
import io.github.mmm.code.api.arg.CodeReturn;
import io.github.mmm.code.api.block.CodeBlockInitializer;
import io.github.mmm.code.api.comment.CodeComment;
import io.github.mmm.code.api.doc.CodeDoc;
import io.github.mmm.code.api.element.CodeElement;
import io.github.mmm.code.api.expression.CodeExpression;
import io.github.mmm.code.api.expression.CodeVariable;
import io.github.mmm.code.api.item.CodeItem;
import io.github.mmm.code.api.item.CodeItemWithName;
import io.github.mmm.code.api.item.CodeItemWithQualifiedName;
import io.github.mmm.code.api.language.CodeLanguage;
import io.github.mmm.code.api.member.CodeConstructor;
import io.github.mmm.code.api.member.CodeField;
import io.github.mmm.code.api.member.CodeMethod;
import io.github.mmm.code.api.member.CodeOperation;
import io.github.mmm.code.api.modifier.CodeModifiers;
import io.github.mmm.code.api.modifier.CodeVisibility;
import io.github.mmm.code.api.type.CodeGenericType;
import io.github.mmm.code.api.type.CodeType;
import io.github.mmm.code.api.type.CodeTypeCategory;
import io.github.mmm.code.api.type.CodeTypeVariables;
import java.io.IOException;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCodeLanguage
implements CodeLanguage {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCodeLanguage.class);

    @Override
    public String verifyName(CodeItemWithName item, String name) {
        Pattern pattern = this.getNamePattern(item);
        return this.verifyName(item, pattern, name);
    }

    @Override
    public String verifySimpleName(CodeItemWithQualifiedName item, String simpleName) {
        Pattern pattern;
        if (item instanceof CodePackage) {
            CodePackage parentPackage = ((CodePackage)item).getParentPackage();
            if (parentPackage == null) {
                if (!"".equals(simpleName)) {
                    throw new IllegalArgumentException("Root package name must be empty. It can not be '" + simpleName + "'.");
                }
                return simpleName;
            }
            pattern = this.getSimpleNamePatternForPackage();
        } else if (item instanceof CodeFile) {
            pattern = this.getSimpleNamePatternForType();
        } else if (item instanceof CodeType) {
            pattern = this.getSimpleNamePatternForType();
        } else {
            LOG.debug("Unexepcted item type: {}", (Object)item);
            return simpleName;
        }
        return this.verifyName(item, pattern, simpleName);
    }

    protected String verifyName(CodeItem item, Pattern pattern, String name) {
        boolean valid = false;
        if (name != null) {
            if (!this.isTypeInDefaultPackage(item) && this.isRevervedKeyword(name, item)) {
                throw new ObjectMismatchException((Object)name, (Object)"no reserved keyword");
            }
            if (pattern != null) {
                valid = pattern.matcher(name).matches();
            }
        }
        if (!valid) {
            throw new ObjectMismatchException((Object)name, (Object)pattern);
        }
        return name;
    }

    private boolean isTypeInDefaultPackage(CodeItem item) {
        if (item instanceof CodeFile) {
            return ((CodeFile)item).getParentPackage().isRoot();
        }
        return false;
    }

    protected abstract Pattern getSimpleNamePatternForPackage();

    protected abstract Pattern getSimpleNamePatternForType();

    protected abstract Pattern getNamePattern(CodeItemWithName var1);

    protected abstract boolean isRevervedKeyword(String var1, CodeItem var2);

    public void writeDoc(CodeDoc doc, Appendable sink, String newline, String defaultIndent, String currentIndent) throws IOException {
        if (defaultIndent == null) {
            return;
        }
        doc.write(sink, newline, defaultIndent, currentIndent);
    }

    public void writeComment(CodeComment comment, Appendable sink, String newline, String defaultIndent, String currentIndent) throws IOException {
        if (comment == null) {
            return;
        }
        if (defaultIndent == null) {
            if ("".equals(newline)) {
                return;
            }
            Iterator<String> lines = comment.iterator();
            if (lines.hasNext()) {
                String separator = "/* ";
                while (lines.hasNext()) {
                    String line = lines.next();
                    sink.append(separator);
                    line = line.trim();
                    sink.append(line);
                    separator = " ";
                }
                sink.append(" */");
            }
        } else {
            comment.write(sink, newline, defaultIndent, currentIndent, this);
        }
    }

    public void writeAnnotations(CodeAnnotations annotations, Appendable sink, String newline, String defaultIndent, String currentIndent) throws IOException {
        annotations.write(sink, newline, defaultIndent, currentIndent, this);
    }

    public void writeElement(CodeElement element, Appendable sink, String newline, String defaultIndent, String currentIndent) throws IOException {
        this.writeDoc(element.getDoc(), sink, newline, defaultIndent, currentIndent);
        this.writeComment(element.getComment(), sink, newline, defaultIndent, currentIndent);
        this.writeAnnotations(element.getAnnotations(), sink, newline, defaultIndent, currentIndent);
    }

    @Override
    public void writeDeclaration(CodeVariable variable, Appendable sink) throws IOException {
        variable.writeReference(sink, false);
        sink.append(' ');
        sink.append(variable.getName());
    }

    @Override
    public void writeDeclaration(CodeType type, Appendable sink, String newline, String defaultIndent, String currentIndent) throws IOException {
        sink.append(currentIndent);
        sink.append(this.getTypeModifiers(type).toString());
        CodeTypeCategory category = type.getCategory();
        sink.append(this.getKeywordForCategory(category));
        sink.append(' ');
        type.writeReference(sink, true);
        if (category == CodeTypeCategory.RECORD) {
            sink.append('(');
            String separator = "";
            for (CodeField field : type.getFields().getDeclared()) {
                sink.append(separator);
                this.writeDeclaration(field, sink);
                separator = ", ";
            }
            sink.append(')');
        }
        type.getSuperTypes().write(sink, null, null);
    }

    private CodeModifiers getTypeModifiers(CodeType type) {
        CodeModifiers modifiers = type.getModifiers();
        if (type.isAnnotation() || type.isInterface()) {
            modifiers = modifiers.removeModifier("abstract");
        }
        return modifiers;
    }

    @Override
    public void writeBody(CodeType type, Appendable sink, String newline, String defaultIndent, String currentIndent) throws IOException {
        CodeBlockInitializer nonStaticInitializer;
        CodeBlockInitializer staticInitializer;
        sink.append(" {");
        sink.append(newline);
        String bodyIndent = currentIndent + defaultIndent;
        CodeTypeCategory category = type.getCategory();
        if (category != CodeTypeCategory.RECORD) {
            type.getFields().write(sink, newline, defaultIndent, bodyIndent);
        }
        if ((staticInitializer = type.getStaticInitializer()) != null && !staticInitializer.isEmpty()) {
            sink.append(newline);
            sink.append(bodyIndent);
            staticInitializer.write(sink, newline, defaultIndent, bodyIndent, this);
        }
        if ((nonStaticInitializer = type.getNonStaticInitializer()) != null && !nonStaticInitializer.isEmpty()) {
            sink.append(newline);
            sink.append(bodyIndent);
            nonStaticInitializer.write(sink, newline, defaultIndent, bodyIndent, this);
        }
        type.getConstructors().write(sink, newline, defaultIndent, bodyIndent, this);
        type.getMethods().write(sink, newline, defaultIndent, bodyIndent, this);
        type.getNestedTypes().write(sink, newline, defaultIndent, bodyIndent, this);
        sink.append(currentIndent);
        sink.append("}");
        sink.append(newline);
    }

    @Override
    public void writeField(CodeField field, Appendable sink, String newline, String defaultIndent, String currentIndent) throws IOException {
        CodeType declaringType = field.getDeclaringType();
        CodeTypeCategory category = declaringType.getCategory();
        if (category == CodeTypeCategory.RECORD || category == CodeTypeCategory.INTERFACE) {
            return;
        }
        this.writeElement(field, sink, newline, defaultIndent, currentIndent);
        sink.append(currentIndent);
        sink.append(field.getModifiers().toString());
        this.writeDeclaration(field, sink);
        CodeExpression initializer = field.getInitializer();
        if (initializer != null) {
            sink.append(" = ");
            initializer.write(sink, "", "");
        }
        sink.append(';');
        sink.append(newline);
    }

    @Override
    public void writeMethod(CodeMethod method, Appendable sink, String newline, String defaultIndent, String currentIndent) throws IOException {
        this.writeOperation(method, this.getMethodModifiers(method), method.getReturns(), sink, newline, defaultIndent, currentIndent);
    }

    protected void writeOperation(CodeOperation operation, CodeModifiers modifiers, CodeReturn opReturn, Appendable sink, String newline, String defaultIndent, String currentIndent) throws IOException {
        this.writeElement(operation, sink, newline, defaultIndent, currentIndent);
        sink.append(currentIndent);
        sink.append(modifiers.toString());
        if (opReturn != null) {
            sink.append(this.getMethodKeyword());
        }
        this.writeTypeVariables(operation.getTypeParameters(), sink, newline, defaultIndent, currentIndent);
        if (opReturn != null) {
            this.writeTypeReferenceBegin(opReturn.getType(), sink, newline, defaultIndent, currentIndent);
        }
        sink.append(this.getOperationName(operation));
        this.writeParameters(operation.getParameters(), sink, newline, defaultIndent, currentIndent);
        if (opReturn != null) {
            this.writeTypeReferenceEnd(opReturn.getType(), sink, newline, defaultIndent, currentIndent);
        }
        operation.getExceptions().write(sink, newline, null, null, this);
        this.writeBody(operation, sink, newline, defaultIndent, currentIndent);
    }

    protected String getOperationName(CodeOperation operation) {
        return operation.getName();
    }

    protected void writeTypeReferenceBegin(CodeGenericType type, Appendable sink, String newline, String defaultIndent, String currentIndent) throws IOException {
        type.writeReference(sink, false);
        sink.append(' ');
    }

    protected void writeTypeReferenceEnd(CodeGenericType type, Appendable sink, String newline, String defaultIndent, String currentIndent) throws IOException {
    }

    protected CodeModifiers getMethodModifiers(CodeMethod method) {
        CodeType declaringType = method.getDeclaringType();
        CodeModifiers modifiers = method.getModifiers();
        if (declaringType.getCategory().isInterfaceOrAnnotation()) {
            if (modifiers.isPublic()) {
                modifiers = modifiers.changeVisibility(CodeVisibility.DEFAULT);
            }
            if (modifiers.isAbstract()) {
                modifiers = modifiers.removeModifier("abstract");
            }
        } else if (modifiers.isDefaultModifier()) {
            LOG.warn("Method {}.{}: omitting default modifier that is only allowed in interface.", (Object)declaringType.getQualifiedName(), (Object)method.getName());
            modifiers = modifiers.removeModifier("default");
        }
        return modifiers;
    }

    @Override
    public void writeConstructor(CodeConstructor constructor, Appendable sink, String newline, String defaultIndent, String currentIndent) throws IOException {
        this.writeOperation(constructor, constructor.getModifiers(), null, sink, newline, defaultIndent, currentIndent);
    }

    public void writeParameters(CodeParameters parameters, Appendable sink, String newline, String defaultIndent, String currentIndent) throws IOException {
        sink.append('(');
        parameters.write(sink, newline, null, null, this);
        sink.append(')');
    }

    public void writeTypeVariables(CodeTypeVariables typeVariables, Appendable sink, String newline, String defaultIndent, String currentIndent) throws IOException {
        if (!typeVariables.getDeclared().isEmpty()) {
            typeVariables.write(sink, newline, defaultIndent, currentIndent, this);
            sink.append(' ');
        }
    }

    public void writeBody(CodeOperation operation, Appendable sink, String newline, String defaultIndent, String currentIndent) throws IOException {
        if (!operation.canHaveBody() || defaultIndent == null) {
            sink.append(this.getStatementTerminator());
            sink.append(newline);
        } else {
            sink.append(' ');
            operation.getBody().write(sink, newline, defaultIndent, currentIndent, this);
        }
    }
}

