/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.code.api.language;

import io.github.mmm.code.api.CodeFile;
import io.github.mmm.code.api.CodePackage;
import io.github.mmm.code.api.expression.CodeVariable;
import io.github.mmm.code.api.item.CodeItemWithName;
import io.github.mmm.code.api.item.CodeItemWithQualifiedName;
import io.github.mmm.code.api.member.CodeConstructor;
import io.github.mmm.code.api.member.CodeField;
import io.github.mmm.code.api.member.CodeMethod;
import io.github.mmm.code.api.statement.CodeLocalVariable;
import io.github.mmm.code.api.type.CodeType;
import io.github.mmm.code.api.type.CodeTypeCategory;
import java.io.IOException;

public interface CodeLanguage {
    public String getLanguageName();

    public String getVariableNameThis();

    public String getKeywordForVariable(CodeLocalVariable var1);

    public void writeDeclaration(CodeVariable var1, Appendable var2) throws IOException;

    public void writeDeclaration(CodeType var1, Appendable var2, String var3, String var4, String var5) throws IOException;

    public void writeBody(CodeType var1, Appendable var2, String var3, String var4, String var5) throws IOException;

    public void writeField(CodeField var1, Appendable var2, String var3, String var4, String var5) throws IOException;

    public void writeMethod(CodeMethod var1, Appendable var2, String var3, String var4, String var5) throws IOException;

    public void writeConstructor(CodeConstructor var1, Appendable var2, String var3, String var4, String var5) throws IOException;

    default public String getKeywordForExtends() {
        return " extends ";
    }

    default public String getKeywordForImplements() {
        return " implements ";
    }

    public String getKeywordForCategory(CodeTypeCategory var1);

    default public String getMethodKeyword() {
        return "";
    }

    public String getStatementTerminator();

    default public String getAnnotationStart() {
        return "@";
    }

    default public String getAnnotationEndIfEmpty() {
        return "";
    }

    default public char getPackageSeparator() {
        return '.';
    }

    public String verifyName(CodeItemWithName var1, String var2);

    public String verifySimpleName(CodeItemWithQualifiedName var1, String var2);

    public String getPackageFilename(CodePackage var1);

    public String getFileFilename(CodeFile var1);

    default public boolean isSupportingNativeProperties() {
        return false;
    }
}

